fun transform(value: Any) =
    if (value is Object)
        // REFORMAT THE OBJECT TO USE INDEXES AS KEYS, SO THAT WE CAN MAINTAIN THE ORDER
        (value as Object) mapObject {
            // USE INDEX AS KEY
            ($$$) : {
                // STORE THE REAL KEY
                'key': write($$, 'application/dw', { 'ignoreSchema' : true }),

                // RECURSIVELY TRANSFORM THE MAP'S VALUES
                'value' : transform((value as Object)[$$$]),

                // ADD ATTRIBUTES, IF THERE ARE ANY
                ('attributes': (value as Object)[$$$].@ mapObject {
                    (write($$, 'application/dw', { 'ignoreSchema' : true })) :
                    write($, 'application/dw', { 'ignoreSchema' : true })
                }) if((value as Object)[$$$].@ is Object),

                // ADD NAMESPACE AS OBJECT, IF IT IS DEFINED
                ('namespace': (value as Object)[$$$].# as Object) if (not isEmpty((value as Object)[$$$].#.prefix)),
            }
        }

    else if (value is Array)
        // RECURSIVELY TRANSFORM THE LIST'S VALUES
        value as Array map transform($)

    else
        // WRITE THE VALUE AS A DW SCRIPT
        write(value, 'application/dw', { 'ignoreSchema' : true })
