%dw 2.0
import * from scripts::graphql::GraphqlModule
import getMuleNamespaces from scripts::modules::SharedComponentsModule
import getSchemaLocations from scripts::asyncapi::protocol::ProtocolAdapterModule
import getProtocols, getMuleNamespacesByProtocolSchemas, getAsyncApiSchemaLocation from scripts::asyncapi::AsyncApiModule

input api application/json
input configsContent application/java
input specification text/plain
output application/xml defaultNamespace="http://www.mulesoft.org/schema/mule/core"

var namespaces =
    specification match {
        case spec if (spec == "GraphQL") ->
            getMuleNamespaces(scripts::graphql::GraphqlModule::graphqlSchemaLocations)
        case spec if (spec contains "ASYNC") -> do {
            var schemas = [getAsyncApiSchemaLocation()] ++ getSchemaLocations(getProtocols(api))
            ---
            getMuleNamespacesByProtocolSchemas(schemas)
        }
        else -> {}
    }

var content = 
    specification match {
        case spec if (spec == "GraphQL") ->
            configsContent map read($,"application/xml").mule filter $ != null
        case spec if (spec contains "ASYNC") -> do {
            configsContent map read($,"application/xml").mule filter $ != null
            reduce ((item, acc = {}) -> acc ++ item as Object)
            distinctBy ((value, key) -> key)
        }
        else -> {}
    }
---
mule @((namespaces)) :
{
   (content)
}
