%dw 2.0
import fail from dw::Runtime
import scripts::asyncapi::protocol::KafkaModule
import scripts::asyncapi::protocol::AnypointMQModule
import scripts::asyncapi::protocol::SolaceModule
import scripts::asyncapi::protocol::SalesforcePlatformEventsModule
import * from scripts::modules::PropertiesModule

var protocolOrder = {
    "kafka": 0,
    "anypointmq": 1,
    "solace": 2,
    "salesforcepubsub": 3
}

fun scaffoldAsyncApiConfigs(api, protocols: Array<String>) =
    protocols orderBy protocolOrder[$] map (
        $ match  {
            case name if (name contains "kafka") -> KafkaModule::scaffoldAsyncApiConfig(api)
            case name if (name contains "anypointmq") -> AnypointMQModule::scaffoldAsyncApiConfig(api)
            case name if (name contains "solace") -> SolaceModule::scaffoldAsyncApiConfig(api)
            case name if (name contains "salesforcepubsub") -> SalesforcePlatformEventsModule::scaffoldAsyncApiConfig(api)
            else -> fail('Unsupported protocol: ' ++ $)
        }
    )

fun scaffoldProtocolConfigs(api, protocols: Array<String>, existingConfiguration) =
    protocols orderBy protocolOrder[$] map (
        $ match {
                case name if (name contains "kafka") ->
                    KafkaModule::scaffoldConfigs(api, existingConfiguration)
                case name if (name contains "anypointmq") ->
                    AnypointMQModule::scaffoldConfigs(api, existingConfiguration)
                case name if (name contains "solace") ->
                    SolaceModule::scaffoldConfigs(api, existingConfiguration)
                case name if (name contains "salesforcepubsub") ->
                    SalesforcePlatformEventsModule::scaffoldConfigs(api, existingConfiguration)
                else -> fail('Unsupported protocol: ' ++ $)
        }
    )

/*
 * Given an array of protocol names, return an array of
 * corresponding schema locations.
 */
fun getSchemaLocations(protocols: Array<String>): Array<String> =
    protocols orderBy protocolOrder[$] map (
        $ match {
            case name if (name contains "kafka") -> KafkaModule::getSchemaLocation()
            case name if (name contains "anypointmq") -> AnypointMQModule::getSchemaLocation()
            case name if (name contains "solace") -> SolaceModule::getSchemaLocation()
            case name if (name contains "salesforcepubsub") -> SalesforcePlatformEventsModule::getSchemaLocation()
            else -> fail('Unsupported protocol: ' ++ $)
        }
    )

fun getEnvironmentFile(api, protocols, apiPath) =
    protocols orderBy protocolOrder[$] reduce ((protocol, acc = []) ->
        protocol match {
            case name if (name contains "kafka") -> acc ++ KafkaModule::getEnvironmentFile(api, apiPath)
            case name if (name contains "anypointmq") -> acc ++ AnypointMQModule::getEnvironmentFile(api, apiPath)
            case name if (name contains "solace") -> acc ++ SolaceModule::getEnvironmentFile(api, apiPath)
            case name if (name contains "salesforcepubsub") -> acc ++ SalesforcePlatformEventsModule::getEnvironmentFile(api, apiPath)
            else -> fail('Unsupported protocol: ' ++ $)
        }
    )
