package org.mule.tooling.troubleshooting.ui;

import static org.mule.tooling.core.analytics.Events.DIAGNOSTIC_TROUBLESHOOTING_PERFORMED;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.troubleshooting.CreateTroubleshootingRunnable;
import org.mule.tooling.troubleshooting.collectors.Collector;
import org.mule.tooling.troubleshooting.collectors.TroubleshootingCollectorsManager;

public class TroubleshootingExportWizard extends Wizard implements INewWizard {

    public static final String TITLE = "Troubleshooting Export Tool";

    private TroubleshootingExportSelectionPage troubleshootingDiagnosticPage;

    private List<WizardPage> collectorsPage = new ArrayList<>();

    public TroubleshootingExportWizard() {
    }

    @Override
    public boolean performFinish() {
        try {
            getContainer().run(true, true, new CreateTroubleshootingRunnable(troubleshootingDiagnosticPage.getFolder()));
            AnalyticsRecordsFactory.single(DIAGNOSTIC_TROUBLESHOOTING_PERFORMED).track();
        } catch (InvocationTargetException e) {
            MuleCorePlugin.logError("Error while collection troubleshotting information", e.getCause());
            e.printStackTrace();
        } catch (InterruptedException e) {
            MuleCorePlugin.logError("Error while collection troubleshotting information", e.getCause());
        }
        return true;
    }

    /*
     * (non-Javadoc)
     *
     * @see org.eclipse.jface.wizard.Wizard#addPages()
     */
    @Override
    public void addPages() {
        setWindowTitle(getTitle());
        troubleshootingDiagnosticPage = new TroubleshootingExportSelectionPage();
        addPage(troubleshootingDiagnosticPage);

        TroubleshootingCollectorsManager collectorsManager = TroubleshootingCollectorsManager.getInstance();
        for (Collector collector : collectorsManager) {
            Optional<WizardPage> pageOpt = collector.getWizardPage();
            if (pageOpt.isPresent()) {
                WizardPage page = pageOpt.get();
                collectorsPage.add(page);
                addPage(page);
            }
        }

    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        setNeedsProgressMonitor(true);
    }

    public String getTitle() {
        return TITLE;
    }

    public TroubleshootingExportSelectionPage getTroubleshootingDiagnosticPage() {
        return troubleshootingDiagnosticPage;
    }

    @Override
    public boolean canFinish() {
        if (troubleshootingDiagnosticPage.getFolder() == null) {
            return false;
        }
        for (WizardPage page : collectorsPage) {
            if (!page.isPageComplete())
                return false;
        }
        return true;
    }

}
