package org.mule.tooling.troubleshooting.ui;

import java.io.File;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.mule.tooling.troubleshooting.collectors.Collector;
import org.mule.tooling.troubleshooting.collectors.TroubleshootingCollectorsManager;
import org.mule.tooling.ui.common.FolderChooserComposite;

public class TroubleshootingExportSelectionPage extends WizardPage {

    public static final String PAGE_TITLE = "Troubleshooting Diagnostic Settings";

    public static final String PAGE_DESCRIPTION = "Configure Troubleshooting Diagnostic Tool to gather information about Studio current state. This information will be compressed in a zip file.";

    private static final String PAGE_NAME = "troubleshootingDiagnosticPage";

    public static final String PAGE_DISABLE = " (Disable) ";

    /** Widget for choosing root folder to leave the zip file */
    private FolderChooserComposite rootChooser;
    private File exportFolder;

    private Composite container;

    public TroubleshootingExportSelectionPage(String pageTitle, String pageDescription) {
        super(PAGE_NAME);
        setTitle(pageTitle);
        setDescription(pageDescription);

    }

    public TroubleshootingExportSelectionPage() {
        this(PAGE_TITLE, PAGE_DESCRIPTION);
    }

    private void setEnabled(Control control, boolean state) {
        control.setEnabled(state);
        if (control instanceof Composite) {
            Composite composite = (Composite) control;
            for (Control c : composite.getChildren()) {
                setEnabled(c, state);
            }
        }
    }

    @Override
    public void createControl(Composite parent) {
        container = new Composite(parent, SWT.NONE);
        GridLayout layout = new GridLayout();
        container.setLayout(layout);
        layout.numColumns = 1;

        TroubleshootingCollectorsManager collectorsManager = TroubleshootingCollectorsManager.getInstance();

        SelectionAdapter selectionAdapter = new SelectionAdapter() {

            @Override
            public void widgetSelected(SelectionEvent event) {
                Button button = (Button) event.widget;
                Collector collector = (Collector) button.getData();
                collector.setEnabled(button.getSelection());
                collector.getWizardPage().ifPresent(page -> {
                    setEnabled(page.getControl(), button.getSelection());
                    page.setPageComplete(!button.getSelection());
                    if (!button.getSelection()) {
                        page.setTitle(page.getTitle() + PAGE_DISABLE);
                    } else {
                        page.setTitle(page.getTitle().substring(0, page.getTitle().indexOf(PAGE_DISABLE)));
                    }
                });
                getWizard().getContainer().updateButtons();
            }
        };

        for (Collector collector : collectorsManager) {
            Button check = new Button(container, SWT.CHECK);
            check.setText(collector.getName());
            check.setToolTipText(collector.getDescription());
            check.addSelectionListener(selectionAdapter);
            check.setSelection(true);
            check.setData(collector);
        }

        Label pkgLabel = new Label(container, SWT.NULL);
        pkgLabel.setText("Export to Folder:");
        pkgLabel.setToolTipText("Choose folder where zip file will be exported");
        GridData data = new GridData(GridData.BEGINNING);
        data.widthHint = 120;
        pkgLabel.setLayoutData(data);

        rootChooser = new FolderChooserComposite(container, SWT.NULL);
        rootChooser.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        rootChooser.addSelectionListener(new ISelectionListener() {

            @Override
            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (updateSelectedFolder()) {
                    setPageComplete(true);
                    getWizard().getContainer().updateButtons();
                }
            }
        });

        setControl(container);
        setPageComplete(false);
    }

    /**
     * Updates the selected folder.
     */
    protected boolean updateSelectedFolder() {
        exportFolder = new File(rootChooser.getFolderPath());
        return exportFolder.exists() && exportFolder.canWrite();
    }

    @Override
    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && exportFolder != null && exportFolder.canWrite();
    }

    @Override
    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    public File getFolder() {
        return exportFolder;
    }
}
