package org.mule.tooling.troubleshooting.ui;

import java.util.List;
import java.util.function.Function;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.builder.ApiProjectNature;
import org.mule.tooling.core.builder.MuleNature;

public class ProjectsSelectionPage extends WizardPage implements ICheckStateListener {

    public static final String PAGE_TITLE = "Projects selection";

    private static final String PAGE_NAME = "troubleshootingProjectsSelectionPage";
    private static final String PAGE_DESCRIPTION = "Select Projects to be added to zip file.";

    private Composite container;
    ProjectsChooserComponent projectsChooserComponent;

    private List<IProject> selectedProjects;

    protected ProjectsSelectionPage(String pageTitle, String description) {
        super(PAGE_NAME);
        setTitle(pageTitle);
        setDescription(description);
    }

    public ProjectsSelectionPage() {
        this(PAGE_TITLE, PAGE_DESCRIPTION);
    }

    @Override
    public void createControl(Composite parent) {
        container = new Composite(parent, SWT.NONE);
        GridLayout layout = new GridLayout();
        container.setLayout(layout);

        List<IProject> projects = MuleRuntime.getProjectsThatMatchAndTransform((project) -> {
            try {
                return project.isAccessible() && (project.hasNature(MuleNature.NATURE_ID) || project.hasNature(ApiProjectNature.NATURE_ID));
            } catch (CoreException e) {
                MuleCorePlugin.logError(e.getMessage(), e);
            }
            return false;
        }, Function.identity());

        projectsChooserComponent = new ProjectsChooserComponent("Projects to export", projects.toArray(new IProject[projects.size()]));
        projectsChooserComponent.createControl(container);
        projectsChooserComponent.addCheckStateListener(this);

        setControl(container);
        setPageComplete(false);
    }

    public List<IProject> getSelectedProjects() {
        return selectedProjects;
    }

    @Override
    public void checkStateChanged(CheckStateChangedEvent event) {
        List<IProject> projectsList = projectsChooserComponent.getCheckedProjects();
        setPageComplete(!projectsList.isEmpty());
        selectedProjects = projectsList;
        getWizard().getContainer().updateButtons();
    }

}
