package org.mule.tooling.troubleshooting.ui;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.mule.tooling.apidesigner.project.apiproject.ApiProjectHelper;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.MuleProjectKind;

public class ProjectsContentProvider implements ITreeContentProvider {

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean hasChildren(Object element) {
        Object[] elementChildren = getChildren(element);
        return elementChildren != null && elementChildren.length > 0;
    }

    @Override
    public Object getParent(Object element) {
        return null;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        IProject[] allProjects = (IProject[]) inputElement;
        Set<Object> filteredMuleProjects = new HashSet<>();
        for (IProject project : allProjects) {

            try {
                if (MuleProjectKind.APPLICATION.classifies(project)) {
                    filteredMuleProjects.add(project);
                } else if (MuleProjectKind.DOMAIN.classifies(project)) {
                    filteredMuleProjects.add(project);
                } else if (ApiProjectHelper.isApiProject(project)) {
                    filteredMuleProjects.add(project);
                }
            } catch (CoreException e) {
                MuleCorePlugin.logError(e.getMessage(), e);
            }
        }
        return filteredMuleProjects.toArray();
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IMuleDomain) {
            IMuleDomain muleDomain = (IMuleDomain) parentElement;
            try {
                return muleDomain.getChildProjects().toArray();
            } catch (CoreException e) {
                MuleCorePlugin.logError("Cannot get projects for domain " + muleDomain.getDomainName(), e);
            }
        }
        return null;
    }

}
