package org.mule.tooling.troubleshooting.ui;

import java.io.File;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class DialogWithLink extends MessageDialog {

    File file;

    public DialogWithLink(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, File directory, int dialogImageType, int defaultIndex,
            String... dialogButtonLabels) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, defaultIndex, dialogButtonLabels);
        file = directory;
    }

    @Override
    protected Control createCustomArea(Composite parent) {
        Link link = new Link(parent, SWT.WRAP);
        link.setText("To open file location click <a>here</a>.");
        link.addSelectionListener(new SelectionAdapter() {

            @Override
            public void widgetSelected(SelectionEvent e) {
                Program.launch(file.getAbsolutePath());

            }

        });
        return link;
    }

    public static void openInformation(Shell parent, String title, String message, File directory) {
        open(INFORMATION, parent, title, message, directory, SWT.NONE);
    }

    public static void openWarning(Shell parent, String title, String message, File directory) {
        open(WARNING, parent, title, message, directory, SWT.NONE);
    }

    public static boolean open(int kind, Shell parent, String title, String message, File directory, int style) {
        DialogWithLink dialog = new DialogWithLink(parent, title, null, message, directory, kind, 0, new String[] { IDialogConstants.OK_LABEL });
        style &= SWT.SHEET;
        dialog.setShellStyle(dialog.getShellStyle() | style);
        return dialog.open() == 0;
    }

}
