package org.mule.tooling.troubleshooting.collectors;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FileUtils;

public class CollectorThreadDump extends AbstractCollector {

    private static final String NAME = "Thread dump";
    private static final String DESCRIPTION = "Thread dump is added to zip file";
    private static final String THREAD_DUMP_FILE_NAME = "thread_dump.txt";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public List<CollectorError> collect(File outputFolder) {
        List<CollectorError> out = new ArrayList<>();
        File jvm_info = new File(outputFolder, THREAD_DUMP_FILE_NAME);

        try {
            FileUtils.write(jvm_info, generateThreadDump());
        } catch (IOException e) {
            out.add(new CollectorError(this, e.getMessage()));
        }

        return out;
    }

    public static String generateThreadDump() {
        final StringBuilder dump = new StringBuilder();
        final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        final ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100);
        for (ThreadInfo threadInfo : threadInfos) {
            if (threadInfo == null) {
                // Thread could have been terminated, not alive, or don't exist anymore between the getAllThreadIds() and getThreadInfo() calls.
                // JavaDoc of getThreadInfo() says that in those cases a null element will be in the returned array.
                continue;
            }

            dump.append('"');
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            final Thread.State state = threadInfo.getThreadState();
            dump.append("\n   java.lang.Thread.State: ");
            dump.append(state);
            final StackTraceElement[] stackTraceElements = threadInfo.getStackTrace();
            for (final StackTraceElement stackTraceElement : stackTraceElements) {
                dump.append("\n        at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n\n");
        }
        return dump.toString();
    }

}
