package org.mule.tooling.troubleshooting.collectors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FileUtils;

public class CollectorSystemProperties extends AbstractCollector {

    private static final String NAME = "System properties";
    private static final String DESCRIPTION = "System properties are added to zip file";
    private static final String SP_INFO_FILE_NAME = "system_properties.txt";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public List<CollectorError> collect(File outputFolder) {
        List<CollectorError> out = new ArrayList<>();
        ArrayList<String> lines = new ArrayList<>();
        System.getProperties().forEach((k, v) -> lines.add(k + "=" + v));
        ;

        File system_properties = new File(outputFolder, SP_INFO_FILE_NAME);

        try {
            FileUtils.writeLines(system_properties, lines);
        } catch (IOException e) {
            out.add(new CollectorError(this, e.getMessage()));
        }
        ;

        return out;
    }

}
