package org.mule.tooling.troubleshooting.collectors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Platform;

public class CollectorStudioIni extends AbstractCollector {

    private static final String NAME = "Studio .ini";
    private static final String INI_FILE = "AnypointStudio.ini";
    private static final String DESCRIPTION = "AnypointStudio.ini is added to zip file";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public List<CollectorError> collect(File outputFolder) {
        List<CollectorError> out = new ArrayList<CollectorError>();

        final String installationPath = Platform.getInstallLocation().getURL().getPath();
        File studioIni = new File(installationPath, INI_FILE);

        if (studioIni.exists()) {
            try {
                FileUtils.copyFileToDirectory(studioIni, outputFolder);
            } catch (IOException e) {
                out.add(new CollectorError(this, e.getMessage()));
            }
        }
        return out;
    }

}
