package org.mule.tooling.troubleshooting.collectors;

import java.io.File;
import java.util.List;
import java.util.Optional;

import org.eclipse.jface.wizard.WizardPage;

public interface Collector {

    public String getName();

    public String getDescription();

    public boolean isEnabled();

    public void setEnabled(boolean enabled);

    /**
     * Collects related information
     * 
     * @param file
     *            directory where all information should be placed.
     */
    public List<CollectorError> collect(File outputFolder);

    public Optional<WizardPage> getWizardPage();
}
