package org.mule.tooling.troubleshooting.collectors;

import java.util.Optional;

import org.eclipse.jface.wizard.WizardPage;

public abstract class AbstractCollector implements Collector {

    private boolean enabled;
    private WizardPage wizardPage;

    public AbstractCollector(WizardPage wizardPage) {
        this();
        this.wizardPage = wizardPage;
    }

    public AbstractCollector() {
        enabled = true;
    }

    @Override
    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Optional<WizardPage> getWizardPage() {
        return Optional.ofNullable(wizardPage);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AbstractCollector other = (AbstractCollector) obj;
        if (getName() == null) {
            if (other.getName() != null)
                return false;
        } else if (!getName().equals(other.getName()))
            return false;
        return true;
    }

}
