package org.mule.tooling.troubleshooting;

import static org.mule.tooling.core.analytics.Events.DIAGNOSTIC_TROUBLESHOOTING_OPEN;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.troubleshooting.collectors.CollectorLogs;
import org.mule.tooling.troubleshooting.collectors.CollectorProjects;
import org.mule.tooling.troubleshooting.collectors.CollectorStudioIni;
import org.mule.tooling.troubleshooting.collectors.CollectorSystemProperties;
import org.mule.tooling.troubleshooting.collectors.CollectorThreadDump;
import org.mule.tooling.troubleshooting.collectors.TroubleshootingCollectorsManager;
import org.mule.tooling.troubleshooting.ui.ProjectsSelectionPage;
import org.mule.tooling.troubleshooting.ui.TroubleshootingExportWizard;

public class TroubleshootingExportHandler extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {

        createAndAddDefaultCollectors();

        final IWorkbench workbench = PlatformUI.getWorkbench();
        final Shell shell = workbench.getActiveWorkbenchWindow().getShell();

        final TroubleshootingExportWizard wizard = new TroubleshootingExportWizard();
        wizard.init(workbench, new StructuredSelection());

        final WizardDialog dialog = new WizardDialog(shell, wizard);

        dialog.create();

        dialog.open();

        AnalyticsRecordsFactory.single(DIAGNOSTIC_TROUBLESHOOTING_OPEN).track();

        return null;
    }

    private void createAndAddDefaultCollectors() {
        TroubleshootingCollectorsManager manager = TroubleshootingCollectorsManager.getInstance();
        manager.registerCollector(new CollectorLogs());
        manager.registerCollector(new CollectorProjects(new ProjectsSelectionPage()));
        manager.registerCollector(new CollectorStudioIni());
        manager.registerCollector(new CollectorSystemProperties());
        manager.registerCollector(new CollectorThreadDump());
    }

}
