package amf.graphql.internal.spec.domain

import amf.core.client.scala.model.domain.AmfScalar
import amf.core.client.scala.model.domain.extensions.PropertyShape
import amf.core.internal.metamodel.domain.extensions.PropertyShapeModel
import amf.core.internal.parser.domain.Annotations.{inferred, synthesized}
import amf.graphql.internal.spec.context.GraphQLBaseWebApiContext
import amf.graphql.internal.spec.parser.syntax.TokenTypes._
import amf.graphql.internal.spec.parser.syntax.{GraphQLASTParserHelper, NullableShape}
import amf.graphqlfederation.internal.spec.domain.{
  ExternalDirectiveParser,
  FederationMetadataParser,
  ProvidesParser,
  RequiresParser,
  ShapeFederationMetadataFactory
}
import amf.shapes.client.scala.model.domain.{AnyShape, NodeShape}
import org.mulesoft.antlrast.ast.Node
import amf.graphql.internal.spec.document._
case class GraphQLPropertyFieldParser(ast: Node, parent: NodeShape)(implicit val ctx: GraphQLBaseWebApiContext)
    extends GraphQLASTParserHelper {
  val property: PropertyShape = PropertyShape(toAnnotations(ast))

  def parse(setterFn: PropertyShape => Unit): Unit = {
    parseName()
    setterFn(property)
    parseDescription(ast, property, property.meta)
    parseRange()
    parseFederationMetadata()
    GraphQLDirectiveApplicationsParser(ast, property).parse()
  }

  private def parseName(): Unit = {
    val (name, annotations) = findName(ast, "AnonymousField", "Missing name for field")
    property.withName(name, annotations)
  }

  private def parseRange(): Unit = {
    val range = parseType(ast)
    unpackNilUnion(range) match {
      case NullableShape(true, shape)  => makeNullable(shape, nullable = true)
      case NullableShape(false, shape) => makeNullable(shape, nullable = false)
    }
  }

  private def makeNullable(shape: AnyShape, nullable: Boolean): Unit = {
    val minCount = if (nullable) 0 else 1
    property set shape as PropertyShapeModel.Range
    property set minCount as PropertyShapeModel.MinCount
  }

  private def parseFederationMetadata(): Unit = {
    inFederation { implicit fCtx =>
      FederationMetadataParser(
        ast,
        property,
        Seq(FIELD_DIRECTIVE, FIELD_FEDERATION_DIRECTIVE),
        ShapeFederationMetadataFactory
      ).parse()
      FederationMetadataParser(
        ast,
        property,
        Seq(INPUT_VALUE_DIRECTIVE, INPUT_FIELD_FEDERATION_DIRECTIVE),
        ShapeFederationMetadataFactory
      ).parse()
      GraphQLDirectiveApplicationsParser(ast, property, Seq(FIELD_DIRECTIVE, DIRECTIVE)).parse()
      GraphQLDirectiveApplicationsParser(ast, property, Seq(INPUT_VALUE_DIRECTIVE, DIRECTIVE)).parse()
      ExternalDirectiveParser(ast, property).parse()
      ProvidesParser(ast, property).parse()
      RequiresParser(ast, property, parent).parse()
    }
  }

}
