package amf.graphql.internal.spec.context

import amf.apicontract.client.scala.model.domain.security.SecurityScheme
import amf.apicontract.internal.spec.common.WebApiDeclarations
import amf.apicontract.internal.spec.common.emitter.SpecVersionFactory
import amf.apicontract.internal.spec.common.parser.{SecuritySchemeParser, WebApiContext}
import amf.core.client.scala.config.ParsingOptions
import amf.core.client.scala.model.domain.Shape
import amf.core.client.scala.parse.document.{ParsedReference, ParserContext}
import amf.core.internal.plugins.syntax.SyamlAMFErrorHandler
import amf.core.internal.remote.{GraphQL, Grpc, Spec}
import amf.shapes.internal.spec.raml.parser.RamlWebApiContextType.RamlWebApiContextType
import amf.shapes.internal.spec.common.{JSONSchemaDraft4SchemaVersion, SchemaVersion}
import amf.shapes.internal.spec.common.parser.{
  AnnotationSchemaValidatorBuilder,
  DontIgnoreCriteria,
  IgnoreAnnotationSchemaValidatorBuilder,
  IgnoreCriteria,
  SpecSettings,
  SpecSyntax,
  YMapEntryLike
}
import org.yaml.model.{YNode, YPart}

object GraphQLBaseVersionFactory extends SpecVersionFactory {
  override def securitySchemeParser: (YMapEntryLike, SecurityScheme => SecurityScheme) => SecuritySchemeParser =
    throw new Exception("GraphQL specs don't support security schemes")
}

object GraphQLBaseWebApiContext {
  object RootTypes extends Enumeration {
    val Query, Subscription, Mutation = Value
  }
}

abstract class GraphQLBaseWebApiContext(
    override val loc: String,
    override val refs: Seq[ParsedReference],
    override val options: ParsingOptions,
    protected val wrapped: ParserContext,
    protected val specSettings: GraphQLBaseSettings,
    protected val ds: Option[WebApiDeclarations] = None
) extends WebApiContext(loc, refs, options, wrapped, ds, specSettings = specSettings) {

  override def autoGeneratedAnnotation(s: Shape): Unit = {}

  override val factory: SpecVersionFactory = GraphQLBaseVersionFactory

}

trait GraphQLBaseSettings extends SpecSettings {
  override val spec: Spec
  override val syntax: SpecSyntax = SpecSyntax.empty

  override def link(node: YNode)(implicit eh: SyamlAMFErrorHandler): Either[String, YNode] = throw new Exception(
    "GrpcContext cannot be used with a SYaml parser"
  )

  override def ignoreCriteria: IgnoreCriteria = DontIgnoreCriteria

  override def ramlContextType: Option[RamlWebApiContextType] = None

  override val defaultSchemaVersion: SchemaVersion                          = JSONSchemaDraft4SchemaVersion
  override val annotationValidatorBuilder: AnnotationSchemaValidatorBuilder = IgnoreAnnotationSchemaValidatorBuilder
}
