
/*
 * generated by Xtext 2.29.0
 */
lexer grammar InternalDFLLexer;


@header {
package org.mule.tooling.dfl.parser.antlr.lexer;

// Hack: Use our own Lexer superclass by means of import.
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
import java.util.Set;
import java.util.HashSet;
import java.util.Deque;
import java.util.ArrayDeque;
import java.util.Arrays;
}

@members {
	protected static final List<Character> SEPARATORS = Arrays.asList('"', '\'', '!', '#', '$', '(', ')', '*', '+', ',', '.', '/', ':', '<', '=', '>', '?', 
        '[', ']', '{', '}', '|', '%', '^', '@', '\r', '\n', ' ', '\t');
	public static final List<String> KEYWORDS = Arrays.asList(
			"if",
		    "else",
		    "unless",
		    "using",
		    // "---", // STUDIO SIDE: separator won't be used here as it is not valid from Xtext grammar
		    "as",
		    "is",
		    "null",
		    "true",
		    "false",
		    "default",
		    "case",
		    "fun",
		    "input",
		    "output",
		    "ns",
		    "type",
		    "import",
		    "annotation",
		    "var",
		    // "match",
		    // "update",
		    "and",
		    "or",
		    // added to avoid future conflicts and breaking changes, we can remove them later.
		    // but we wanna ensure that we are no breaking something in the near future
		    // "try", // allowing try as an identifier (on Studio side)
		    "catch",
		    "throw",
		    "do",
		    "for",
		    "yield",
		    "enum",
		    // "private", // allowing try as an identifier (on Studio side)
		    "async");
	
	protected List<String> coreFunctions = Arrays.asList(
		"find", 
		"replace", 
		"contains", 
		"matches", 
		"match", 
		"scan", 
		"splitBy"
	);
	
	protected Set<String> functions = new HashSet<>(coreFunctions);
	
	protected Deque<Token> tokens = new ArrayDeque<Token>();

	protected Token inputToken;
	protected Token outputToken;
	protected Token caseToken;

	protected Token previousToken;

	@Override
	public void emit(Token token) {
		super.emit(token);
		
		// add to known functions if previous token was Fun(ction)
		if (previousToken != null && previousToken.getType() == Fun) {
			functions.add(token.getText());
		}
		
		if (!isWhitespace(token) && !isEOL(token)) {
			previousToken = token;
		}
		if (token.getType() == Input) {
			inputToken = token;
		} else if (token.getType() == Output) {
			outputToken = token;
		} else if (token.getType() == Case) {
			caseToken = token;
		}
		addToken(token);
	}

	@Override
    public Token nextToken() {
        super.nextToken();
        if (tokens.isEmpty()) {
        	return Token.EOF_TOKEN;
        }
        return tokens.removeFirst();
    }

	protected void addToken(Token token) {
		tokens.add(token);
	}

	protected boolean isWhitespace(Token token) {
		return token.getType() == RULE_WS;
	}

	protected boolean isEOL(Token token) {
		return token.getType() == RULE_EOL;
	}

	protected boolean isMimeType() {
		return previousToken != null && ((previousToken.getType() == Output) || (previousToken.getType() == RULE_UNQUOTED_STRING && isInputLine()));
	}
	
	protected boolean isNamespacePrefix() {
		return isAfterNamespaceKeyword();
	}

	protected boolean isNamespaceUri() {
		return previousToken != null && previousToken.getType() == RULE_NAMESPACE_PREFIX;
	}

	protected boolean isInsideUnquotedString() {
		return previousToken != null && previousToken.getType() == RULE_UNQUOTED_STRING;
	}

	protected boolean isOptionValue() {
		return previousToken != null && previousToken.getType() == EqualsSign && isDirectiveWithOptionsLine();
	}

	protected boolean isAsExpression() {
		return previousToken != null && previousToken.getType() == As;
	}

	protected boolean isIsExpression() {
		return previousToken != null && previousToken.getType() == Is;
	}

	protected boolean isRegularExpression() {
		return isKeywordForRegex(previousToken) || isInRegexContext(previousToken);
	}
	
	protected boolean isInRegexContext(Token token) {
		if (token == null) {
			return true;	
		} 

		switch (token.getType()) {
			case LeftParenthesis: // might be inside a function call
			case Comma: // might be inside a function call
			case Colon: // as a value in a key value pair
			case HyphenMinusHyphenMinusHyphenMinus: // as the first of a script
			case EqualsSign:
				return true;
			default:
				// check if the token is a function that might accept regex expressions
				return functions.contains(token.getText());
		}
	}
	
	protected boolean isKeywordForRegex(Token token) {
		return token != null && token.getType() == Matches;
	}

	protected boolean isCommentValid() {
		int previousChar = input.LA(-1);
		return previousChar == '\t' || previousChar == ' ' || previousChar == '\r' || previousChar == '\n' || previousChar == ',' || previousChar == CharStream.EOF;
	}

	protected boolean isNonQuotedStringEnd() {
		int nextChar = input.LA(1);
		return nextChar == '.' || nextChar == '@' || nextChar == '(' || nextChar == ')' || nextChar == ':'| nextChar == ',' || nextChar == '\r' || nextChar == '\n' || nextChar == ']' || nextChar == '}';
	}

	// This method checks the keyword which we use to finish the unquoted string in all conditions
	protected boolean isSpecialKeyword() {
		return checkKeyword("@(");
	}

	protected boolean isIsolatedKeyword() {
		boolean isWhitespace = (input.LA(-1) == ' ' || input.LA(-1) == '\t');
		return isWhitespace && isKeyword();
	}

	protected boolean allAlpha() {
		char previousChar = (char) input.LA(-1);
		if (!SEPARATORS.contains(previousChar)) {
			return false;
		}

	    int i = 1;

		char nextChar = (char) input.LA(i);
	    while (!SEPARATORS.contains(nextChar)) {
	        if (!Character.isLetter(nextChar)) {
	            return false;
	        }
	        nextChar = (char) input.LA(++i);
	    }

		return true;
	}

	protected boolean isKeyword() {
		boolean isKey = false;
		for (String keyword : KEYWORDS) {
			isKey |= checkKeyword(keyword);
		}
		return  isKey ||
				checkKeyword("~", false) ||
				checkKeyword("if", false) ||
				checkKeyword("else", false) ||
				checkKeyword("default", false) ||
				checkKeyword("matches", false) ||
				checkKeyword("matches") ||
				(checkKeyword("with") && isDirectiveWithOptionsLine()) ||
				checkKeyword("false") ||
				//checkKeyword("match", false) ||
				checkKeywordBlock("match") ||
				checkKeywordBlock("update") ||
				checkKeyword("using") ||
				checkKeyword("output") ||
				checkKeyword("input") ||
				checkKeyword("var") ||
				checkKeyword("fun") ||
				checkKeyword("from") ||
				checkKeyword("ns") ||
				checkKeyword("type") ||
				checkKeyword("import") ||
				checkKeyword("annotation") ||
				// checkKeyword("try") || // allowing trying as an identifier (on Studio side)
				checkKeyword("catch") ||
				checkKeyword("throw") ||
				checkKeyword("do") ||
				checkKeyword("for") ||
				checkKeyword("const") ||
				checkKeyword("yield") ||
				checkKeyword("enum") ||
				// checkKeyword("private") || // allowing try as an identifier (on Studio side)
				checkKeyword("public") ||
				checkKeyword("lazy") ||
				checkKeyword("implicit") ||
				checkKeyword("export") ||
				checkKeyword("extends") ||
				// checkKeyword("module") ||
				checkKeyword("async") ||
				checkKeyword("case") ||
				(checkKeyword("at") && isInCase()) ||
				checkKeyword("null") ||
				checkKeyword("true") ||
				checkKeyword("when", false) ||
				checkKeyword("---") ||
				checkKeyword("..*") ||
				checkKeyword("..@") ||
				checkKeyword("..^") ||
				checkKeyword("..&") ||
				checkKeyword("and", false) ||
				checkKeyword("not", false) ||
				checkKeyword("!=") ||
				checkKeyword("{") ||
				checkKeyword("}") ||
				checkKeyword("[") ||
				checkKeyword("]") ||
				checkKeyword("$$") ||
				checkKeyword("++") ||
				checkKeyword("--") ||
				checkKeyword("->") ||
				checkKeyword(".*") ||
				checkKeyword("..") ||
				checkKeyword(".@") ||
				checkKeyword(".^") ||
				checkKeyword(".&") ||
				checkKeyword("<<") ||
				checkKeyword("<=") ||
				checkKeyword("==") ||
				checkKeyword("~=") ||
				checkKeyword(">=") ||
				checkKeyword("@(") ||
				checkKeyword("[*") ||
				checkKeyword("[@") ||
				checkKeyword("Object") ||
				checkKeyword("Array") ||
				checkKeyword("Type") ||
				checkKeyword("[^") ||
				checkKeyword("^(") ||
				checkKeyword("as", false) ||
				checkKeyword("is", false) ||
				checkKeyword("or", false) ||
				checkKeyword("+", false) ||
				checkKeyword("-", false);
	}

	private CommonToken createCommonToken(Token prototype) {
        return new CommonToken(prototype);
    }

	private boolean isAfterNamespaceKeyword() {
		return previousToken != null && previousToken.getType() == Ns;
	}

	private boolean checkKeyword(String keyword) {
		return checkKeyword(keyword, true);
	}

	private boolean checkKeyword(String keyword, boolean isWhitespaceOrNewLineOptional) {
		int i = 0;
		int index = 1;
		while (i < keyword.length() ) {
			if ( input.LA(index) != keyword.charAt(i) ) {
				return false;
			}
			i++;
			index++;
		}
		int nextChar = input.LA(index);
		return (isWhitespaceOrNewLineOptional || nextChar == ' ' || nextChar == '\t' || nextChar == '\r' || nextChar == '\n') && !(isInRange(nextChar, 'a', 'z') || isInRange(nextChar, 'A', 'Z') || isInRange(nextChar, '0', '9') || nextChar == '_');
	}

	private boolean checkKeywordBlock(String keyword) {
		int i = 0;
		int index = 1;
		while (i < keyword.length() ) {
			if ( input.LA(index) != keyword.charAt(i) ) {
				return false;
			}
			i++;
			index++;
		}
		int nextChar = input.LA(index);
		while (nextChar == ' ' || nextChar == '\t' || nextChar == '\r' || nextChar == '\n') {
			index++;
			nextChar = input.LA(index);
		}
		return nextChar == '{';
	}
	
	private boolean isInputLine() {
		int currentLine = input.getLine();
		return inputToken != null && inputToken.getLine() == currentLine;
	}
	
	private boolean isDirectiveWithOptionsLine() {
		int currentLine = input.getLine();
		return ((inputToken != null && inputToken.getLine() == currentLine) || (outputToken != null && outputToken.getLine() == currentLine));
	}
	
	private boolean isInCase() {
		int currentLine = input.getLine();
		return (caseToken != null && caseToken.getLine() == currentLine);
	}

	// This method is not being used we can remove it in the future
	private boolean isPrefixBeingUsed() {
		int index = 1;
		int nextChar = input.LA(index);
		while (nextChar != CharStream.EOF && (nextChar != '_' || nextChar != '-' || isInRange(nextChar, 'a', 'z') || isInRange(nextChar, 'A', 'Z') || isInRange(nextChar, '0', '9'))) {
			if (nextChar == '#') {
				return true;
			}
			index++;
			nextChar = input.LA(index);
		}
		return false;
	}

	private boolean isInRange(int nextChar, int lowerBound, int upperBound) {
		return nextChar >= lowerBound && nextChar <= upperBound;
	}
}





Annotation : 'annotation';

Default : 'default';

Matches : 'matches';

Object : 'Object';

Import : 'import';

Output : 'output';

Unless : 'unless';

Update : 'update';

Array : 'Array';

False : 'false';

Input : 'input';

Match : 'match';

Using : 'using';

FullStopFullStopAmpersandSpace : '..& ';

FullStopFullStopAsteriskSpace : '..* ';

FullStopFullStopCommercialAtSpace : '..@ ';

FullStopFullStopCircumflexAccentSpace : '..^ ';

Type : 'Type';

Case : 'case';

Else : 'else';

From : 'from';

Null : 'null';

True : 'true';

Type_1 : 'type';

With : 'with';

Dw : '%dw';

HyphenMinusHyphenMinusHyphenMinus : '---';

FullStopNumberSignSpace : '.# ';

FullStopAmpersandSpace : '.& ';

FullStopAsteriskSpace : '.* ';

FullStopFullStopSpace : '.. ';

FullStopFullStopAmpersand : '..&';

FullStopFullStopAsterisk : '..*';

FullStopFullStopCommercialAt : '..@';

FullStopFullStopCircumflexAccent : '..^';

FullStopCommercialAtSpace : '.@ ';

FullStopCircumflexAccentSpace : '.^ ';

QuestionMarkQuestionMarkQuestionMark : '???';

And : 'and';

Fun : 'fun';

Not : 'not';

Var : 'var';

LeftCurlyBracketHyphenMinusVerticalLine : '{-|';

VerticalLineHyphenMinusRightCurlyBracket : '|-}';

ExclamationMarkEqualsSign : '!=';

PlusSignPlusSign : '++';

HyphenMinusHyphenMinus : '--';

HyphenMinusGreaterThanSign : '->';

HyphenMinusRightCurlyBracket : '-}';

FullStopSpace : '. ';

FullStopNumberSign : '.#';

FullStopAmpersand : '.&';

FullStopAsterisk : '.*';

FullStopFullStop : '..';

FullStopCommercialAt : '.@';

FullStopCircumflexAccent : '.^';

ColonColon : '::';

LessThanSignColon : '<:';

LessThanSignEqualsSign : '<=';

LessThanSignTilde : '<~';

EqualsSignEqualsSign : '==';

GreaterThanSignEqualsSign : '>=';

CommercialAtLeftParenthesis : '@(';

LeftSquareBracketAmpersand : '[&';

LeftSquareBracketAsterisk : '[*';

LeftSquareBracketCommercialAt : '[@';

LeftSquareBracketCircumflexAccent : '[^';

As : 'as';

At : 'at';

Do : 'do';

If : 'if';

Is : 'is';

Ns : 'ns';

Or : 'or';

LeftCurlyBracketHyphenMinus : '{-';

LeftCurlyBracketVerticalLine : '{|';

VerticalLineRightCurlyBracket : '|}';

TildeEqualsSign : '~=';

ExclamationMark : '!';

NumberSign : '#';

DollarSign : '$';

Ampersand : '&';

LeftParenthesis : '(';

RightParenthesis : ')';

Asterisk : '*';

PlusSign : '+';

Comma : ',';

HyphenMinus : '-';

FullStop : '.';

Solidus : '/';

Colon : ':';

Semicolon : ';';

LessThanSign : '<';

EqualsSign : '=';

GreaterThanSign : '>';

QuestionMark : '?';

CommercialAt : '@';

LeftSquareBracket : '[';

RightSquareBracket : ']';

LeftCurlyBracket : '{';

VerticalLine : '|';

RightCurlyBracket : '}';

Tilde : '~';



RULE_VALID_TYPE_NAME : {!isKeyword() && !isNamespacePrefix()}?=> ('a'..'z' | 'A'..'Z')+;

RULE_BACKTICK_STRING : '`' ('\\' .|~(('\\'|'`')))* '`'?;

RULE_STRING : ('"' ('\\' .|'$(' ('(' ( options {greedy=false;} : . )*')'|~(('('|')')))* ')'|~(('\\'|'"')))* '"'|'\'' ('\\' .|'$(' ('(' ( options {greedy=false;} : . )*')'|~(('('|')')))* ')'|~(('\\'|'\'')))* '\'');

RULE_INT : RULE_DIGIT+;

RULE_EXPONENTIAL : RULE_DIGIT+ ('e'|'E') RULE_DIGIT+;

RULE_ANY_DATE : '|' ~((' '|'\n'|'\r'|'\t'|'|'|'>'|'}'))* '|';

RULE_ANY_REGEX : {isRegularExpression()}?=> '/' ('\\/' | ~('/'))+ '/';

RULE_UNQUOTED_STRING : {!isKeyword() && !isNamespacePrefix() && !isNamespaceUri() && !allAlpha()}?=> ~(RULE_NON_QUOTED_STRING_START) ({!isIsolatedKeyword() && !isSpecialKeyword() && !allAlpha()}?=> ~(RULE_NON_QUOTED_STRING_END))*;

RULE_WS : (' '|'\t')+;

RULE_SL_COMMENT : {!isNamespaceUri()}?=> '//' ~(RULE_LINE_BREAK)*;

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_EOL : RULE_LINE_BREAK;

RULE_NAMESPACE_PREFIX : {isNamespacePrefix()}?=> ('a'..'z' | 'A'..'Z' | '0'..'9' | '_' | '-')*;

RULE_NAMESPACE_URI : {isNamespaceUri()}?=> ('a'..'z' | 'A'..'Z' | '0'..'9' | '_' | '-' | '.' | ':' | '?' | '=' | '/')*;

fragment RULE_LINE_BREAK : ('\r'|'\n');

fragment RULE_DIGIT : '0'..'9';

fragment RULE_NON_QUOTED_STRING_START : ('"'|'\''|'`'|'0'..'9'|'!'|'#'|'$'|'('|')'|'*'|'+'|','|'-'|'.'|'/'|':'|'<'|'='|'>'|'?'|'['|']'|'{'|'}'|'|'|'%'|'^'|'@'|'\r'|'\n'|' '|'\t'|'&'|'~');

fragment RULE_NON_QUOTED_STRING_END : ('!'|'#'|'$'|'('|')'|'*'|','|'.'|':'|'<'|'='|'>'|'?'|'['|']'|'{'|'}'|'|'|'%'|'^'|'\r'|'\n'|' '|'\t'|'`'|'&'|'~');



