/*
 * generated by Xtext 2.29.0
 */
grammar DebugInternalDFL ;

// Rule Document
ruleDocument :
	ruleBody?
;

// Rule Body
ruleBody :
	( (
	ruleContent
	) => ruleContent ) |
	ruleHeader (
		ruleHeaderSeparator ruleContent
	)?
;

// Rule Header
ruleHeader :
	ruleDirective+
;

// Rule HeaderSeparator
ruleHeaderSeparator :
	'---'
;

// Rule Directive
ruleDirective :
	ruleAnnotatedDirective |
	ruleVersionDirective |
	ruleNamespaceDirective |
	ruleVariableDirective |
	ruleTypeDirective |
	ruleFunctionDirective |
	ruleOutputDirective |
	ruleInputDirective |
	ruleImportDirective |
	ruleAnnotationDirective
;

// Rule AnnotatedDirective
ruleAnnotatedDirective :
	ruleAnnotation+ (
		ruleAnnotationDirective |
		ruleVersionDirective |
		ruleVariableDirective |
		ruleTypeDirective |
		ruleFunctionDirective |
		ruleImportDirective
	)
;

// Rule AnnotationDirective
ruleAnnotationDirective :
	'annotation' ruleIdentifier '(' (
		ruleAnnotationParameter (
			',' ruleAnnotationParameter
		)*
	)? ')'
;

// Rule AnnotationParameter
ruleAnnotationParameter :
	ruleIdentifier ':' ruleTypeExpression (
		'=' ruleExpression
	)?
;

// Rule Annotation
ruleAnnotation :
	'@' ruleFullQualifiedTypeName ( (
	'(' (
		ruleVariableDefinition (
			',' ruleVariableDefinition
		)*
	)? ')'
	) => (
		'(' (
			ruleVariableDefinition (
				',' ruleVariableDefinition
			)*
		)? ')'
	) )?
;

// Rule ImportDirective
ruleImportDirective :
	'import' (
		ruleImportWithSubElements |
		ruleImportModuleOnly
	)
;

// Rule ImportModuleOnly
ruleImportModuleOnly :
	ruleFullQualifiedTypeName (
		'as' ruleIdentifier
	)?
;

// Rule ImportWithSubElements
ruleImportWithSubElements :
	ruleImportedElement (
		',' ruleImportedElement
	)* 'from' ruleFullQualifiedTypeName
;

// Rule ImportedElement
ruleImportedElement :
	'*' |
	ruleIdentifier (
		'as' ruleIdentifier
	)?
;

// Rule VersionDirective
ruleVersionDirective :
	ruleVersionNumber
;

// Rule VersionNumber
ruleVersionNumber :
	'%dw' RULE_WS+ RULE_INT '.' RULE_INT
;

// Rule NamespaceDirective
ruleNamespaceDirective :
	'ns' ruleNamespacePrefix ruleNamespaceUri
;

// Rule VariableDirective
ruleVariableDirective :
	'var' ruleIdentifier (
		':' ruleTypeExpression
	)? '=' ruleExpression
;

// Rule TypeExpression
ruleTypeExpression :
	ruleAnnotation* ruleIntersectionTypeExpression (
		'|' ruleIntersectionTypeExpression
	)*
;

// Rule IntersectionTypeExpression
ruleIntersectionTypeExpression :
	ruleBasicTypeExpression (
		'&' ruleBasicTypeExpression
	)*
;

// Rule BasicTypeExpression
ruleBasicTypeExpression :
	(
		ruleArrayType |
		ruleObjectSimpleType |
		ruleTypeReference |
		( (
		'(' (
			ruleFunctionTypeParameter (
				',' ruleFunctionTypeParameter
			)*
		)? ')' '->'
		) => ruleFunctionType ) |
		ruleEnclosedTypeExpression |
		ruleLiteralType
	) ruleMetadataInjection?
;

// Rule MetadataInjection
ruleMetadataInjection :
	(
		( (
		'<~'
		) => '<~' ) ruleUnaryExpression
	)+
;

// Rule LiteralType
ruleLiteralType :
	(
		ruleQuotedStringLiteral |
		ruleBooleanLiteral |
		ruleIntegerLiteral |
		ruleRealLiteral
	) ( (
	'{'
	) => ruleSchema )?
;

// Rule EnclosedTypeExpression
ruleEnclosedTypeExpression :
	'(' ruleTypeExpression ')' ( (
	'{'
	) => ruleSchema )?
;

// Rule FunctionType
ruleFunctionType :
	( (
	'(' (
		ruleFunctionTypeParameter (
			',' ruleFunctionTypeParameter
		)*
	)? ')' '->'
	) => (
		'(' (
			ruleFunctionTypeParameter (
				',' ruleFunctionTypeParameter
			)*
		)? ')' '->'
	) ) ruleTypeExpression ruleSchema?
;

// Rule FunctionTypeParameter
ruleFunctionTypeParameter :
	(
		ruleIdentifier '?'? ':'
	)? ruleTypeExpression
;

// Rule ObjectSimpleType
ruleObjectSimpleType :
	(
		'{' (
			ruleKeyValuePairType (
				',' ruleKeyValuePairType
			)* ','?
		)? '}' |
		'{|' (
			ruleKeyValuePairType (
				',' ruleKeyValuePairType
			)* ','?
		)? '|}' |
		'{-|' (
			ruleKeyValuePairType (
				',' ruleKeyValuePairType
			)* ','?
		)? '|-}' |
		'{-' (
			ruleKeyValuePairType (
				',' ruleKeyValuePairType
			)* ','?
		)? '-}'
	) ( (
	'{'
	) => ruleSchema )?
;

// Rule KeyValuePairType
ruleKeyValuePairType :
	(
		'(' ruleTypeReference ')' |
		ruleAnnotation* ruleNamespace? ruleStringLiteral ruleAttributeTypes?
	) '*'? '?'? ':' ruleTypeExpression
;

// Rule AttributeTypes
ruleAttributeTypes :
	'@(' (
		ruleAttributeType (
			',' ruleAttributeType
		)*
	)? ','? ')'
;

// Rule AttributeType
ruleAttributeType :
	ruleNamespace? ruleStringLiteral '?'? ':' ruleTypeExpression
;

// Rule TypeReference
ruleTypeReference :
	ruleFullQualifiedTypeName (
		'<' ruleTypeExpression (
			',' ruleTypeExpression
		)* '>'
	)? (
		'.' ruleSelector
	)* ( (
	'{'
	) => ruleSchema )?
;

// Rule FullQualifiedTypeName
ruleFullQualifiedTypeName :
	ruleLoaderName? ruleFullQualifiedNamePrefix ruleIdentifier
;

// Rule FullQualifiedNamePrefix
ruleFullQualifiedNamePrefix :
	(
		ruleIdentifier '::'
	)*
;

// Rule LoaderName
ruleLoaderName :
	ruleIdentifier '!'
;

// Rule Namespace
ruleNamespace :
	ruleIdentifier '#'
;

// Rule ArrayType
ruleArrayType :
	'Array' (
		'<' ruleTypeExpression '>'
	)? ( (
	'{'
	) => ruleSchema )?
;

// Rule InputDirective
ruleInputDirective :
	'input' ruleIdentifier (
		':' ruleTypeExpression
	)? ruleMimeType? ruleOptions?
;

// Rule OutputDirective
ruleOutputDirective :
	'output' (
		':' ruleTypeExpression
	)? ruleMimeType (
		( (
		'with'
		) => 'with' ) RULE_VALID_TYPE_NAME
	)? ruleOptions?
;

// Rule MimeType
ruleMimeType :
	(
		RULE_UNQUOTED_STRING |
		RULE_VALID_TYPE_NAME
	) (
		'/' (
			RULE_UNQUOTED_STRING |
			RULE_VALID_TYPE_NAME
		)
	)? (
		';' (
			ruleQuotedStringLiteral |
			RULE_UNQUOTED_STRING |
			RULE_VALID_TYPE_NAME
		) '=' (
			ruleQuotedStringLiteral |
			RULE_UNQUOTED_STRING |
			RULE_VALID_TYPE_NAME
		)
	)*
;

// Rule TypeDirective
ruleTypeDirective :
	'type' ruleIdentifier ruleTypeParameterList? '=' (
		ruleTypeExpression |
		'???'
	)
;

// Rule FunctionDirective
ruleFunctionDirective :
	'fun' ruleIdentifier ruleFunctionLiteral
;

// Rule FunctionLiteral
ruleFunctionLiteral :
	ruleTypeParameterList? '(' (
		ruleFunctionParameter (
			',' ruleFunctionParameter
		)*
	)? ')' (
		':' (
			ruleTypeExpression |
			'?'
		)
	)? '=' ruleExpression
;

// Rule LambdaLiteral
ruleLambdaLiteral :
	( (
	ruleTypeParameterList? '(' (
		ruleFunctionParameter (
			',' ruleFunctionParameter
		)*
	)? ')' (
		':' (
			ruleTypeExpression |
			'?'
		)
	)? '->'
	) => (
		ruleTypeParameterList? '(' (
			ruleFunctionParameter (
				',' ruleFunctionParameter
			)*
		)? ')' (
			':' (
				ruleTypeExpression |
				'?'
			)
		)? '->'
	) ) ruleExpression
;

// Rule TypeParameterList
ruleTypeParameterList :
	'<' ruleTypeParameterType (
		',' ruleTypeParameterType
	)* '>'
;

// Rule TypeParameterType
ruleTypeParameterType :
	ruleIdentifier (
		'<:' ruleTypeExpression
	)?
;

// Rule Schema
ruleSchema :
	'{' (
		ruleSchemaElement (
			',' ruleSchemaElement
		)* ','?
	)? '}'
;

// Rule SchemaElement
ruleSchemaElement :
	( (
	'(' (
		ruleIdentifier |
		ruleQuotedStringLiteral
	) ':' ruleExpression ')' 'if'
	) => ruleConditionalSchemaElement ) |
	ruleSimpleSchemaElement
;

// Rule SimpleSchemaElement
ruleSimpleSchemaElement :
	(
		ruleIdentifier |
		ruleQuotedStringLiteral
	) ':' ruleExpression
;

// Rule ConditionalSchemaElement
ruleConditionalSchemaElement :
	( (
	'(' (
		ruleIdentifier |
		ruleQuotedStringLiteral
	) ':' ruleExpression ')' 'if'
	) => (
		'(' (
			ruleIdentifier |
			ruleQuotedStringLiteral
		) ':' ruleExpression ')' 'if'
	) ) ruleExpression
;

// Rule Options
ruleOptions :
	ruleOptionElement (
		',' ruleOptionElement?
	)*
;

// Rule OptionElement
ruleOptionElement :
	ruleIdentifier '=' ruleLiteralValue
;

// Rule Content
ruleContent :
	ruleExpression
;

// Rule SingleKeyValuePairObj
ruleSingleKeyValuePairObj :
	ruleKeyValuePair
;

// Rule MultipleKeyValuePairObj
ruleMultipleKeyValuePairObj :
	'{' (
		( (
		'}'
		) => '}' ) |
		ruleObjectElements '}'
	) |
	'{|' (
		( (
		'|}'
		) => '|}' ) |
		ruleObjectElements '|}'
	) |
	'{-|' (
		( (
		'|-}'
		) => '|-}' ) |
		ruleObjectElements '|-}'
	) |
	'{-' (
		( (
		'-}'
		) => '-}' ) |
		ruleObjectElements '-}'
	)
;

// Rule ObjectElements
ruleObjectElements :
	ruleObjectElement (
		( (
		','
		) => ',' ) ruleObjectElement |
		','
	)*
;

// Rule ObjectElement
ruleObjectElement :
	( (
	'('
	) => ruleEnclosedObjectElement ) |
	ruleKeyValuePair (
		'~' ruleExpression
	)?
;

// Rule KeyValuePair
ruleKeyValuePair :
	ruleKey ':' ruleExpression
;

// Rule EnclosedObjectElement
ruleEnclosedObjectElement :
	( (
	'('
	) => '(' ) ruleExpression ')' (
		'if' ruleExpression |
		ruleAttributes? ':' ruleExpression (
			'~' ruleExpression
		)?
	)?
;

// Rule Key
ruleKey :
	ruleAnnotation* ruleDeclaredNamespace? ruleKeyExpression ruleAttributes?
;

// Rule KeyExpression
ruleKeyExpression :
	(
		ruleStringLiteral |
		ruleRealLiteral |
		ruleIntegerLiteral |
		ruleBooleanLiteral |
		ruleAnyDateLiteral
	) |
	ruleNullLiteral
;

// Rule DeclaredNamespace
ruleDeclaredNamespace :
	ruleIdentifier '#'
;

// Rule Attributes
ruleAttributes :
	'@(' (
		ruleAttributeElement (
			',' ruleAttributeElement
		)*
	)? ','? ')'
;

// Rule AttributeElement
ruleAttributeElement :
	( (
	'(' ruleAnnotation* ruleDeclaredNamespace? ruleIdentifier ':' ruleExpression
	')' 'if'
	) => ruleConditionalAttribute ) |
	ruleAttribute
;

// Rule Attribute
ruleAttribute :
	ruleAnnotation* ruleDeclaredNamespace? (
		ruleIdentifier |
		ruleQuotedStringLiteral
	) ':' ruleExpression |
	ruleEnclosedExpression (
		':' ruleExpression
	)?
;

// Rule ConditionalAttribute
ruleConditionalAttribute :
	( (
	'(' ruleAnnotation* ruleDeclaredNamespace? ruleIdentifier ':' ruleExpression
	')' 'if'
	) => (
		'(' ruleAnnotation* ruleDeclaredNamespace? ruleIdentifier ':' ruleExpression
		')' 'if'
	) ) ruleExpression
;

// Rule Expression
ruleExpression :
	( (
	ruleAnnotation+ ruleHighLevelExpression
	) => (
		ruleAnnotation+ ruleHighLevelExpression
	) ) |
	ruleHighLevelExpression
;

// Rule HighLevelExpression
ruleHighLevelExpression :
	ruleOrExpression (
		'update' '{' (
			'case' ruleUpdateCase
		)+ '}' |
		'match' '{' (
			'case' (
				ruleRegexPattern |
				ruleTypePattern |
				ruleLiteralPattern |
				ruleNamedPattern |
				ruleDeconstructPattern
			) |
			'else' ruleIdentifier? '->' ruleDefaultPattern
		)* '}' |
		( (
		'default'
		) => 'default' ) ruleOrExpression |
		ruleVariable (
			'<' ruleTypeExpression (
				',' ruleTypeExpression
			)* '>'
		)? ruleClojureOperatorOrOrExpression
	)*
;

// Rule UpdateCase
ruleUpdateCase :
	(
		ruleIdentifier 'at' |
		'(' ruleIdentifier ',' ruleIdentifier ')' 'at'
	)? ruleUpdateSelectorExpression '!'? (
		'if' '(' ruleExpression ')'
	)? '->' ruleExpression
;

// Rule UpdateSelectorExpression
ruleUpdateSelectorExpression :
	(
		'.@' ruleSelector ruleUpdateSelectorExpression? |
		'.*' ruleSelector ruleUpdateSelectorExpression? |
		'.' ruleSelector ruleUpdateSelectorExpression?
	) |
	'[' ruleExpression ']' ruleUpdateSelectorExpression?
;

// Rule ClojureOperatorOrOrExpression
ruleClojureOperatorOrOrExpression :
	( (
	ruleClojureOperator
	) => ruleClojureOperator ) |
	ruleOrExpression
;

// Rule NamedPattern
ruleNamedPattern :
	ruleReifiedIdentifier (
		'matches' ruleAnyRegexLiteral '->' ruleExpression |
		':' ruleLiteralValuePattern '->' ruleExpression |
		'is' ruleTypeExpression '->' ruleExpression |
		'if' ruleExpression '->' ruleExpression
	)
;

// Rule ReifiedIdentifier
ruleReifiedIdentifier :
	ruleIdentifier
;

// Rule ClojureOperator
ruleClojureOperator :
	ruleFunctionParameter '->' ruleOrExpression |
	'(' ruleFunctionParameter (
		',' ruleFunctionParameter
	)? ')' '->' ruleOrExpression |
	'(' '(' ruleFunctionParameter (
		',' ruleFunctionParameter
	)? ')' '->' ruleOrExpression ')'
;

// Rule OrExpression
ruleOrExpression :
	ruleAndExpression (
		( (
		'or'
		) => 'or' ) ruleAndExpression
	)*
;

// Rule AndExpression
ruleAndExpression :
	ruleEqualityExpression (
		( (
		'and'
		) => 'and' ) ruleEqualityExpression
	)*
;

// Rule EqualityExpression
ruleEqualityExpression :
	ruleRelationalExpression (
		( (
		'==' |
		'!=' |
		'~='
		) => (
			'==' |
			'!=' |
			'~='
		) ) ruleRelationalExpression
	)*
;

// Rule RelationalExpression
ruleRelationalExpression :
	ruleAdditiveExpression (
		'<' ruleAdditiveExpression |
		'<=' ruleAdditiveExpression |
		'>' ruleAdditiveExpression |
		'>=' ruleAdditiveExpression |
		'is' ruleTypeExpression
	)*
;

// Rule AdditiveExpression
ruleAdditiveExpression :
	ruleMultiplicationDivisionExpression (
		( (
		'+' |
		'-' |
		'>' '>' |
		'<' '<'
		) => (
			'+' |
			'-' |
			'>' '>' |
			'<' '<'
		) ) ruleMultiplicationDivisionExpression
	)*
;

// Rule MultiplicationDivisionExpression
ruleMultiplicationDivisionExpression :
	ruleCoerceExpression (
		( (
		'*' |
		'/'
		) => (
			'*' |
			'/'
		) ) ruleCoerceExpression
	)*
;

// Rule CoerceExpression
ruleCoerceExpression :
	ruleUnaryExpression (
		( (
		'as'
		) => 'as' ) ruleTypeExpression |
		( (
		'<~'
		) => '<~' ) ruleUnaryExpression
	)*
;

// Rule UnaryExpression
ruleUnaryExpression :
	( (
	'???'
	) => '???' ) |
	( (
	'-'
	) => '-' ) ruleOrExpression |
	( (
	'not' |
	'!'
	) => (
		'not' |
		'!'
	) ) ruleOrExpression |
	( (
	'using'
	) => 'using' ) '(' ruleVariableDefinition (
		',' ruleVariableDefinition
	)* ')' ruleExpression |
	'if' '(' ruleExpression ')' ruleExpression 'else' ruleExpression |
	'unless' '(' ruleExpression ')' ruleExpression 'else' ruleExpression |
	'do' '{' ruleBody '}' |
	ruleValueExpression
;

// Rule ValueExpression
ruleValueExpression :
	ruleAtomic (
		(
			( (
			(
				'.. ' |
				'..@ ' |
				'..^ ' |
				'..& ' |
				'..* '
			) |
			(
				'..' |
				'..@' |
				'..^' |
				'..&' |
				'..*'
			) ruleSelector? |
			(
				(
					'. ' |
					'.* '
				) |
				(
					'.' |
					'.*'
				) ruleSelectorOrFunction? |
				(
					'.@ ' |
					'.^ ' |
					'.& ' |
					'.# '
				) |
				(
					'.@' |
					'.^' |
					'.&' |
					'.#'
				) ruleSelector?
			) |
			(
				'[*' ruleSelector |
				(
					'[@' |
					'[^'
				) ruleSelector?
			) ']' |
			(
				'[*' |
				'[@' |
				'[^' |
				'[&' |
				'['
			) ruleExpression ']' |
			'[' ( (
			'?'
			) => '?' ) '(' ruleOrExpression ')' ']' |
			'[' ruleStringSelector ']'
			) => (
				(
					'.. ' |
					'..@ ' |
					'..^ ' |
					'..& ' |
					'..* '
				) |
				(
					'..' |
					'..@' |
					'..^' |
					'..&' |
					'..*'
				) ruleSelector? |
				(
					(
						'. ' |
						'.* '
					) |
					(
						'.' |
						'.*'
					) ruleSelectorOrFunction? |
					(
						'.@ ' |
						'.^ ' |
						'.& ' |
						'.# '
					) |
					(
						'.@' |
						'.^' |
						'.&' |
						'.#'
					) ruleSelector?
				) |
				(
					'[*' ruleSelector |
					(
						'[@' |
						'[^'
					) ruleSelector?
				) ']' |
				(
					'[*' |
					'[@' |
					'[^' |
					'[&' |
					'['
				) ruleExpression ']' |
				'[' ( (
				'?'
				) => '?' ) '(' ruleOrExpression ')' ']' |
				'[' ruleStringSelector ']'
			) ) |
			'(' ruleFunctionCallArgs ')'
		)+ ( (
		'?' |
		'!'
		) => (
			'?' |
			'!'
		) )?
	)?
;

// Rule Atomic
ruleAtomic :
	( (
	ruleTypeParameterList? '(' (
		ruleFunctionParameter (
			',' ruleFunctionParameter
		)*
	)? ')' (
		':' (
			ruleTypeExpression |
			'?'
		)
	)? '->'
	) => ruleLambdaLiteral ) |
	( (
	ruleFullQualifiedTypeName (
		'<' ruleTypeExpression (
			',' ruleTypeExpression
		)* '>'
	)? '('
	) => ruleFunctionCall ) |
	( (
	ruleSingleKeyValuePairObj
	) => ruleSingleKeyValuePairObj ) |
	ruleVariable ruleBacktickStringLiteral? |
	ruleLiteralValue |
	ruleMultipleKeyValuePairObj |
	ruleArray |
	( (
	'('
	) => ruleEnclosedObjectElement )
;

// Rule SelectorOrFunction
ruleSelectorOrFunction :
	( (
	ruleFunctionCall
	) => ruleFunctionCall ) |
	ruleSelector
;

// Rule EnclosedExpression
ruleEnclosedExpression :
	'(' ruleExpression ')'
;

// Rule Selector
ruleSelector :
	ruleSelectorWithNameSpace |
	(
		ruleKeyword |
		ruleStringLiteral
	)
;

// Rule SelectorWithNameSpace
ruleSelectorWithNameSpace :
	ruleKeywordSelector |
	ruleStringSelector
;

// Rule KeywordSelector
ruleKeywordSelector :
	ruleDeclaredNamespace ruleKeyword
;

// Rule StringSelector
ruleStringSelector :
	ruleDeclaredNamespace ruleStringLiteral
;

// Rule FunctionCall
ruleFunctionCall :
	( (
	ruleFullQualifiedTypeName (
		'<' ruleTypeExpression (
			',' ruleTypeExpression
		)* '>'
	)? '('
	) => (
		ruleFullQualifiedTypeName (
			'<' ruleTypeExpression (
				',' ruleTypeExpression
			)* '>'
		)? '('
	) ) ruleFunctionCallArgs ')'
;

// Rule FunctionCallArgs
ruleFunctionCallArgs :
	(
		ruleExpression (
			',' ruleExpression
		)*
	)?
;

// Rule TypePattern
ruleTypePattern :
	'is' ruleTypeExpression '->' ruleExpression
;

// Rule RegexPattern
ruleRegexPattern :
	'matches' ruleAnyRegexLiteral '->' ruleExpression
;

// Rule LiteralPattern
ruleLiteralPattern :
	ruleLiteralValuePattern '->' ruleExpression
;

// Rule DeconstructPattern
ruleDeconstructPattern :
	( (
	'[' ']' '->'
	) => (
		'[' ']' '->'
	) ) ruleExpression |
	'[' (
		ruleIdentifier '~' ruleIdentifier
	)? ']' '->' ruleExpression |
	( (
	'{' '}' '->'
	) => (
		'{' '}' '->'
	) ) ruleExpression |
	'{' ruleIdentifier ':' ruleIdentifier '~' ruleIdentifier '}' '->'
	ruleExpression
;

// Rule DefaultPattern
ruleDefaultPattern :
	ruleExpression
;

// Rule LiteralValuePattern
ruleLiteralValuePattern :
	ruleRealLiteral |
	ruleIntegerLiteral |
	ruleAnyDateLiteral |
	ruleBooleanLiteral |
	ruleNullLiteral |
	ruleQuotedStringLiteral
;

// Rule Variable
ruleVariable :
	ruleVariableReference |
	ruleDollarVariable
;

// Rule VariableReference
ruleVariableReference :
	ruleFullQualifiedTypeName
;

// Rule DollarVariable
ruleDollarVariable :
	'$'+
;

// Rule FunctionParameter
ruleFunctionParameter :
	ruleAnnotation? ruleIdentifier (
		':' ruleTypeExpression
	)? (
		'=' ruleExpression
	)?
;

// Rule VariableDefinition
ruleVariableDefinition :
	ruleIdentifier '=' ruleExpression
;

// Rule LiteralValue
ruleLiteralValue :
	ruleRealLiteral |
	ruleIntegerLiteral |
	ruleAnyDateLiteral |
	ruleBooleanLiteral |
	ruleNullLiteral |
	ruleAnyRegexLiteral |
	ruleQuotedStringLiteral
;

// Rule NullLiteral
ruleNullLiteral :
	'null'
;

// Rule BooleanLiteral
ruleBooleanLiteral :
	'true' |
	'false'
;

// Rule StringLiteral
ruleStringLiteral :
	ruleQuotedStringLiteral |
	ruleIdentifier
;

// Rule QuotedStringLiteral
ruleQuotedStringLiteral :
	RULE_STRING |
	ruleBacktickStringLiteral
;

// Rule BacktickStringLiteral
ruleBacktickStringLiteral :
	RULE_BACKTICK_STRING
;

// Rule NamespacePrefix
ruleNamespacePrefix :
	RULE_NAMESPACE_PREFIX |
	ruleIdentifier
;

// Rule NamespaceUri
ruleNamespaceUri :
	RULE_NAMESPACE_URI |
	RULE_VALID_TYPE_NAME
;

// Rule IntegerLiteral
ruleIntegerLiteral :
	RULE_INT
;

// Rule RealLiteral
ruleRealLiteral :
	RULE_INT '.' RULE_INT |
	RULE_INT '.' RULE_EXPONENTIAL |
	RULE_EXPONENTIAL '.' RULE_INT |
	RULE_EXPONENTIAL '.' RULE_EXPONENTIAL
;

// Rule AnyDateLiteral
ruleAnyDateLiteral :
	RULE_ANY_DATE
;

// Rule AnyRegexLiteral
ruleAnyRegexLiteral :
	RULE_ANY_REGEX
;

// Rule Keyword
ruleKeyword :
	'true' |
	'false' |
	'null' |
	'not' |
	'Object' |
	'Array' |
	'Type'
;

// Rule Identifier
ruleIdentifier :
	RULE_UNQUOTED_STRING |
	RULE_VALID_TYPE_NAME |
	'++' |
	'--' |
	'Object' |
	'Array' |
	'Type' |
	'matches' |
	'match' |
	'from'
;

// Rule Array
ruleArray :
	'[' (
		( (
		']'
		) => ']' ) |
		ruleArrayElement (
			( (
			']'
			) => ']' ) |
			( (
			'~'
			) => '~' ) ruleArrayTail ']' |
			ruleArrayElements ']'
		)
	)
;

// Rule ArrayTail
ruleArrayTail :
	ruleExpression
;

// Rule ArrayElements
ruleArrayElements :
	(
		',' ruleArrayElement
	)+ ','?
;

// Rule ArrayElement
ruleArrayElement :
	( (
	'(' ruleExpression ')' 'if'
	) => ruleConditionalArrayElement ) |
	ruleExpression
;

// Rule ConditionalArrayElement
ruleConditionalArrayElement :
	( (
	'(' ruleExpression ')' 'if'
	) => (
		'(' ruleExpression ')' 'if'
	) ) ruleExpression
;

RULE_VALID_TYPE_NAME :
	(
		'a' .. 'z' |
		'A' .. 'Z'
	)+
;

RULE_BACKTICK_STRING :
	'`' (
		'\\' . |
		~ (
			'\\' |
			'`'
		)
	)* '`'?
;

RULE_STRING :
	'"' (
		'\\' . |
		'$(' (
			'(' (
				options { greedy = false ; } : .
			)* ')' |
			~ (
				'(' |
				')'
			)
		)* ')' |
		~ (
			'\\' |
			'"'
		)
	)* '"' |
	'\'' (
		'\\' . |
		'$(' (
			'(' (
				options { greedy = false ; } : .
			)* ')' |
			~ (
				'(' |
				')'
			)
		)* ')' |
		~ (
			'\\' |
			'\''
		)
	)* '\''
;

RULE_INT :
	RULE_DIGIT+
;

RULE_EXPONENTIAL :
	RULE_DIGIT+ (
		'e' |
		'E'
	) RULE_DIGIT+
;

RULE_ANY_DATE :
	'|' ~ (
		' ' |
		'\n' |
		'\r' |
		'\t' |
		'|' |
		'>' |
		'}'
	)* '|'
;

RULE_ANY_REGEX :
	'/' (
		'\\/' |
		~ (
			'/'
		)
	)+ '/'
;

RULE_UNQUOTED_STRING :
	~ (
		RULE_NON_QUOTED_STRING_START
	) ~ (
		RULE_NON_QUOTED_STRING_END
	)*
;

RULE_WS :
	(
		' ' |
		'\t'
	)+ { skip(); }
;

RULE_SL_COMMENT :
	'//' ~ (
		RULE_LINE_BREAK
	)* { skip(); }
;

RULE_ML_COMMENT :
	'/*' (
		options { greedy = false ; } : .
	)* '*/' { skip(); }
;

RULE_EOL :
	RULE_LINE_BREAK { skip(); }
;

RULE_NAMESPACE_PREFIX :
	(
		'a' .. 'z' |
		'A' .. 'Z' |
		'0' .. '9' |
		'_'
	)*
;

RULE_NAMESPACE_URI :
	(
		'a' .. 'z' |
		'A' .. 'Z' |
		'0' .. '9' |
		'_' |
		'-' |
		'.' |
		':' |
		'?' |
		'=' |
		'/'
	)*
;

fragment RULE_LINE_BREAK :
	'\r' |
	'\n'
;

fragment RULE_DIGIT :
	'0' .. '9'
;

fragment RULE_NON_QUOTED_STRING_START :
	'"' |
	'\'' |
	'`' |
	'0' .. '9' |
	'!' |
	'#' |
	'$' |
	'(' |
	')' |
	'*' |
	'+' |
	',' |
	'-' |
	'.' |
	'/' |
	':' |
	'<' |
	'=' |
	'>' |
	'?' |
	'[' |
	']' |
	'{' |
	'}' |
	'|' |
	'%' |
	'^' |
	'@' |
	'\r' |
	'\n' |
	' ' |
	'\t' |
	'&' |
	'~'
;

fragment RULE_NON_QUOTED_STRING_END :
	'!' |
	'#' |
	'$' |
	'(' |
	')' |
	'*' |
	',' |
	'.' |
	':' |
	'<' |
	'=' |
	'>' |
	'?' |
	'[' |
	']' |
	'{' |
	'}' |
	'|' |
	'%' |
	'^' |
	'\r' |
	'\n' |
	' ' |
	'\t' |
	'`' |
	'&' |
	'~'
;