# TLS Version Support Script - Amazon Linux Guide

## Overview
This script has been specifically enhanced for Amazon Linux compatibility and includes built-in dependency checking.

## Quick Start

### 1. Check Compatibility (Recommended)
```bash
./checkCompatibility.sh
```
This will verify all dependencies and provide installation instructions if needed.

### 2. Install Dependencies (if needed)

**Amazon Linux 2:**
```bash
sudo yum update
sudo yum install openssl
# timeout command is available by default (part of coreutils)
```

**Amazon Linux 2023:**
```bash
sudo dnf update  
sudo dnf install openssl
# timeout command is available by default (part of coreutils)
```

### 3. Run TLS Tests
```bash
# Use default files
./testTlsVersionSupport.sh

# Or specify your own CSV files
./testTlsVersionSupport.sh your_hosts.csv results.csv
```

## Features for Amazon Linux

### Built-in Compatibility Check
The main script automatically checks for required dependencies and provides Amazon Linux specific installation commands.

### OpenSSL Version Support
- Automatically detects if your OpenSSL version supports TLS 1.2/1.3 flags
- Enhanced error pattern matching for different OpenSSL versions
- Graceful fallback for older OpenSSL installations

### Native Timeout Handling
Uses the standard `timeout` command which is available by default on Amazon Linux (part of coreutils package).

## Troubleshooting

### Missing Dependencies
If you see dependency errors:
1. Run `./checkCompatibility.sh` for detailed diagnosis
2. Install missing packages using the provided commands
3. Verify installation with `./checkCompatibility.sh` again

### Network Connectivity
The compatibility checker includes a basic connectivity test to google.com:443. If this fails:
- Check your network connectivity
- Verify firewall rules allow outbound HTTPS
- Test with internal hosts first

### OpenSSL Issues
If you encounter OpenSSL-related errors:
- Check your OpenSSL version: `openssl version`
- Very old versions might not support TLS 1.3
- The script will mark unsupported TLS versions as ERROR rather than crash

## Expected Output Values

See the main script header for complete documentation of output values:
- **SUPPORTED**: TLS version works correctly
- **NOT_SUPPORTED**: SSL works but TLS version unavailable  
- **NON_SSL**: Port doesn't support SSL/TLS
- **ERROR**: Connection/network failures or unsupported OpenSSL
- **UNTESTED**: Intentionally skipped (port -1)

## Example Usage

```bash
# Create input file
cat > hosts.csv << EOF
Component,Host,Port
Web Server,example.com,443
Database,db.internal,5432
Legacy App,old.system.com,-1
EOF

# Run tests
./testTlsVersionSupport.sh hosts.csv results.csv

# View results
cat results.csv
```

## Performance Considerations

- Default timeout: 10 seconds per test
- Tests run sequentially (not parallel)
- Large host lists may take significant time
- Consider breaking large lists into smaller batches

## Security Notes

- Script makes outbound connections to test TLS
- Ensure firewall rules allow required connectivity
- No sensitive data is transmitted during tests
- All connections use standard OpenSSL tools



