package org.mule.tooling.browser.preference;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mule.tooling.browser.BrowserPlugin;

public class BrowserPreferenceInitializer extends AbstractPreferenceInitializer {

    @Override
    public void initializeDefaultPreferences() {
        final IPreferenceStore preferenceStore = BrowserPlugin.getDefault().getPreferenceStore();
        preferenceStore.setDefault(BrowserPreferencePage.BROWSER_PREFERENCE_KEY, getDefaultPreference());
    }

    public static String getDefaultPreference() {
        if ("native".equalsIgnoreCase(System.getProperty("browser.preference.key", ""))) {
            return BrowserPreference.NATIVE.name();
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            IPreferenceStore store = BrowserPlugin.getDefault().getPreferenceStore();
            String def = store.getDefaultString(BrowserPreferencePage.BROWSER_PREFERENCE_KEY);
            if (!def.isEmpty()) {
                return def;
            }
        }
        return BrowserPreference.BUILT_IN.name();
    }

}
