package org.mule.tooling.browser.impl;

import java.util.function.Function;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationListener;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.mule.tooling.browser.IBrowser;

public class NoBrowser implements IBrowser {

    Composite noBrowser;

    public NoBrowser(Composite parent) {
        this.noBrowser = createNoBrowser(parent);
    }

    private Composite createNoBrowser(Composite parent) {
        noBrowser = new Composite(parent, SWT.NONE);
        GridLayoutFactory.fillDefaults().applyTo(noBrowser);
        GridDataFactory.fillDefaults().applyTo(noBrowser);
        final Label label = new Label(noBrowser, SWT.NONE);
        label.setText("No browser is present.");

        return noBrowser;
    }

    @Override
    public void addOpenWindowListener(Runnable action) {
    }

    @Override
    public void addCloseWindowListener(CloseWindowListener closeWindowListener) {
    }

    @Override
    public void addLocationListener(LocationListener listener) {
    }

    @Override
    public void addAuthenticationListener(AuthenticationListener listener) {
    }

    @Override
    public void addProgressListener(ProgressListener listener) {
    }

    @Override
    public void addStatusTextListener(StatusTextListener listener) {
    }

    @Override
    public void addTitleListener(TitleListener listener) {
    }

    @Override
    public void addVisibilityWindowListener(VisibilityWindowListener listener) {
    }

    @Override
    public boolean back() {
        return false;
    }

    @Override
    public boolean forward() {
        return false;
    }

    @Override
    public boolean execute(String script) {
        return false;
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public void stop() {
    }

    @Override
    public Object evaluate(String script) throws SWTException {
        return null;
    }

    @Override
    public Object evaluate(String script, boolean trusted) throws SWTException {
        return null;
    }

    @Override
    public Composite getComposite() {
        return noBrowser;
    }

    @Override
    public void setJavascriptEnabled(boolean enabled) {
    }

    @Override
    public void setUrl(String url) {
    }

    @Override
    public void setUrl(String url, String info, String[] strings) {
    }

    @Override
    public void setText(String text) {
    }

    @Override
    public void addFunction(String name, Function<Object[], Object> function) {
    }

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public boolean isChromium() {
        return false;
    }

}
