package org.mule.tooling.browser.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

import org.mule.tooling.browser.BrowserPlugin;
import org.mule.tooling.browser.BrowserUtils;
import org.mule.tooling.browser.BrowserUtils.Metric;

@SuppressWarnings("unchecked")
public class BrowserInvocationHandler implements InvocationHandler {

    private final Map<String, Map<Integer, Method>> methods = new HashMap<>();

    private Object target;

    public BrowserInvocationHandler(Object target) {
        this.target = target;

        for (Method method : target.getClass().getDeclaredMethods()) {
            methods.computeIfAbsent(method.getName(), (key) -> new HashMap<Integer, Method>()).put(method.getParameterCount(), method);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        try {
            // handle different methods
            switch (method.getName()) {
            case ("addOpenWindowListener"):
                if (args.length == 1) {
                    if (args[0] instanceof Runnable) {
                        Runnable action = (Runnable) args[0];
                        if (target instanceof org.eclipse.swt.browser.Browser) {
                            ((org.eclipse.swt.browser.Browser) target).addOpenWindowListener(new org.eclipse.swt.browser.OpenWindowListener() {

                                @Override
                                public void open(org.eclipse.swt.browser.WindowEvent event) {
                                    action.run();
                                    event.browser = (org.eclipse.swt.browser.Browser) target;
                                }

                            });
                        } else if (target instanceof com.equo.chromium.swt.Browser) {
                            ((com.equo.chromium.swt.Browser) target).addOpenWindowListener(new com.equo.chromium.swt.OpenWindowListener() {

                                @Override
                                public void open(com.equo.chromium.swt.WindowEvent event) {
                                    action.run();
                                    event.browser = (com.equo.chromium.swt.Browser) target;
                                }

                            });
                        }
                    }
                }
                break;
            case ("getComposite"):
                result = target;
                break;

            case ("addFunction"):
                if (args.length == 2 && args[0] instanceof String) {
                    String name = (String) args[0];
                    Function<Object[], Object> function = (Function<Object[], Object>) args[1];

                    if (target instanceof org.eclipse.swt.browser.Browser) {
                        new org.eclipse.swt.browser.BrowserFunction((org.eclipse.swt.browser.Browser) target, name) {

                            public Object function(Object[] arguments) {
                                BrowserUtils.sendMetric(Metric.FUNCTION_EXEC.apply(name, ((org.eclipse.swt.browser.Browser) target).getUrl()));
                                return function.apply(arguments);
                            };
                        };
                    } else if (target instanceof com.equo.chromium.swt.Browser) {
                        new com.equo.chromium.swt.BrowserFunction((com.equo.chromium.swt.Browser) target, name) {

                            @Override
                            public Object function(Object[] arguments) {
                                BrowserUtils.sendMetric(Metric.FUNCTION_EXEC.apply(name, ((com.equo.chromium.swt.Browser) target).getUrl()));
                                return function.apply(arguments);
                            }
                        };
                    }
                }
                break;
            case ("isChromium"):
                result = target instanceof com.equo.chromium.swt.Browser;
                break;
            default:
                result = methods.get(method.getName()).get(method.getParameterCount()).invoke(target, args);
            }
        } catch (Exception e) {
            BrowserPlugin.logError("Failed to invoke method " + method.getName() + " when trying to open browser", e);
        }

        return result;
    }
}