package org.mule.tooling.browser;

import java.util.function.Function;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationListener;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.widgets.Composite;

public interface IBrowser {

    void addOpenWindowListener(Runnable action);

    void addCloseWindowListener(CloseWindowListener closeWindowListener);

    void addLocationListener(LocationListener listener);

    void addAuthenticationListener(AuthenticationListener listener);

    void addProgressListener(ProgressListener listener);

    void addStatusTextListener(StatusTextListener listener);

    void addTitleListener(TitleListener listener);

    void addVisibilityWindowListener(VisibilityWindowListener listener);

    boolean back();

    boolean forward();

    boolean execute(String script);

    boolean close();

    void stop();

    Object evaluate(String script) throws SWTException;

    Object evaluate(String script, boolean trusted) throws SWTException;

    Composite getComposite();

    void setJavascriptEnabled(boolean enabled);

    void setUrl(String url);

    void setUrl(String url, String info, String[] strings);

    void setText(String text);

    void addFunction(String name, Function<Object[], Object> function);

    String getUrl();

    boolean isChromium();

}
