package org.mule.tooling.browser;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class BrowserPlugin extends AbstractUIPlugin {

    public static final String PLUGIN_ID = "org.mule.tooling.browser";

    private static BrowserPlugin plugin;

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static BrowserPlugin getDefault() {
        return plugin;
    }

    public static void logError(String message, Throwable e) {
        plugin.getLog().log(createLoggingStatus(IStatus.ERROR, message, e));
    }

    private static IStatus createLoggingStatus(int type, String message, Throwable t) {
        return new Status(type, PLUGIN_ID, message, t);
    }

}
