if (!HTMLSlotElement.prototype.assignedElements) {
    console.log("Polyfill HTMLSlotElement.prototype.assignedElements");
    // Workaround for STUDIO-15578, assignedElements are not supported in old browsers.
    HTMLSlotElement.prototype.assignedElements = HTMLSlotElement.prototype.assignedNodes;
}

const apiConsoleApp = 'api-console-app';

function apiModel(model) {
    try {
        let mydata = JSON.parse(model);
        const apic = getApiConsole();
        apic.amf = mydata;
    } catch (e) {
        window.alert('Error trying to render the API Console. ' + e);
    }
}

function emptyModel(model) {
    const request = new XMLHttpRequest();
    request.open("GET", model, false);
    request.send(null);
    let data = request.responseText;
    apiModel(data);
}

function goToSummary() {
    const apic = getApiConsole();
    apic.resetSelection();
}

function turnOnMockingService(url) {
    const apic = getApiConsole();
    apic.allowCustomBaseUri = true;
    apic.serverValue = url;
    apic.disableMessageMockingService = false;
    removeMessageTurnOnMockingService();
}

function turnOffMockingService() {
    const apic = getApiConsole();
    apic.allowCustomBaseUri = false;
    addMessageTurnOnMockingService();
}

function getApiConsole() {
    return document.getElementById(apiConsoleApp);
}

function addMessageTurnOnMockingService() {
    const apic = getApiConsole();
    if((apic.allowCustomBaseUri === false) && (apic.disableMessageMockingService === false || apic.disableMessageMockingService === undefined)) {
        const elem = getTargetElement();
        if(elem != null) {
            const notice = createNotice();
            elem.getElementsByClassName('main-content')[0].prepend(notice);
            apic.disableMessageMockingService = true;
        }
    }
}

function getTargetElement() {
    const apic = getApiConsole();
    let value = null;

    const children = Array.prototype.slice.call(apic.shadowRoot.children);
    children.forEach(function(entry) {
        if(entry.tagName === "APP-DRAWER-LAYOUT") {
            const children2 = Array.prototype.slice.call(entry.children);
            children2.forEach(function(entry2) {
                if(entry2.tagName === "APP-HEADER-LAYOUT") {
                    value = entry2;
                }
            });
        }
    });

    return value;
}

function removeMessageTurnOnMockingService() {
    const elem = getTargetElement();
    if(elem != null) {
        const elements = elem.getElementsByClassName("api-notice-mocking");
        while(elements.length > 0) {
            elements[0].parentNode.removeChild(elements[0]);
        }
    }
}

function createNotice() {
    const newDiv = document.createElement("api-notice-mocking");
    newDiv.part = "api-notice-mocking";
    newDiv.className = "api-notice-mocking";

    const newMessage = document.createElement("p");
    newMessage.part = "message-notice-mocking";
    newMessage.innerHTML = "ⓘ Turn on the Mocking Service, in the top right corner, to test the behavior of your API specification. ";

    const newButtonClose = document.createElement("b");
    newButtonClose.part = "button-close-notice-mocking";
    newButtonClose.type = "button";
    newButtonClose.innerText = "X";
    newButtonClose.onclick = function () {
       this.parentElement.parentElement.removeChild(this.parentElement);
    };

    newDiv.appendChild(newMessage);
    newDiv.appendChild(newButtonClose);

    return newDiv;
}
