/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.AsyncHttpClientState;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.exception.PoolAlreadyClosedException;
import org.asynchttpclient.exception.RemotelyClosedException;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.FilterException;
import org.asynchttpclient.filter.IOExceptionFilter;
import org.asynchttpclient.handler.TransferCompletionHandler;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.OnLastHttpContentCallback;
import org.asynchttpclient.netty.SimpleFutureListener;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.ChannelState;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.channel.ConnectionSemaphore;
import org.asynchttpclient.netty.channel.DefaultConnectionSemaphoreFactory;
import org.asynchttpclient.netty.channel.NettyChannelConnector;
import org.asynchttpclient.netty.channel.NettyConnectListener;
import org.asynchttpclient.netty.handler.StreamedResponsePublisher;
import org.asynchttpclient.netty.request.NettyRequest;
import org.asynchttpclient.netty.request.NettyRequestFactory;
import org.asynchttpclient.netty.request.WriteCompleteListener;
import org.asynchttpclient.netty.request.WriteProgressListener;
import org.asynchttpclient.netty.timeout.TimeoutsHolder;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.resolver.RequestHostnameResolver;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.Assertions;
import org.asynchttpclient.util.AuthenticatorUtils;
import org.asynchttpclient.util.HttpConstants;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.ProxyUtils;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyRequestSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyRequestSender.class);
    private final AsyncHttpClientConfig config;
    private final ChannelManager channelManager;
    private final ConnectionSemaphore connectionSemaphore;
    private final Timer nettyTimer;
    private final AsyncHttpClientState clientState;
    private final NettyRequestFactory requestFactory;

    public NettyRequestSender(AsyncHttpClientConfig config, ChannelManager channelManager, Timer nettyTimer, AsyncHttpClientState clientState) {
        this.config = config;
        this.channelManager = channelManager;
        this.connectionSemaphore = config.getConnectionSemaphoreFactory() == null ? new DefaultConnectionSemaphoreFactory().newConnectionSemaphore(config) : config.getConnectionSemaphoreFactory().newConnectionSemaphore(config);
        this.nettyTimer = nettyTimer;
        this.clientState = clientState;
        this.requestFactory = new NettyRequestFactory(config);
    }

    public <T> ListenableFuture<T> sendRequest(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future) {
        if (this.isClosed()) {
            throw new IllegalStateException("Closed");
        }
        this.validateWebSocketRequest(request, asyncHandler);
        ProxyServer proxyServer = ProxyUtils.getProxyServer(this.config, request);
        if (proxyServer != null && proxyServer.getProxyType().isHttp() && (request.getUri().isSecured() || request.getUri().isWebSocket()) && !this.isConnectAlreadyDone(request, future)) {
            if (future != null && future.isConnectAllowed()) {
                return this.sendRequestWithCertainForceConnect(request, asyncHandler, future, proxyServer, true);
            }
            return this.sendRequestThroughProxy(request, asyncHandler, future, proxyServer);
        }
        return this.sendRequestWithCertainForceConnect(request, asyncHandler, future, proxyServer, false);
    }

    private boolean isConnectAlreadyDone(Request request, NettyResponseFuture<?> future) {
        return future != null && future.getNettyRequest() != null && future.getNettyRequest().getHttpRequest().method() == HttpMethod.CONNECT && !request.getMethod().equals(HttpConstants.Methods.CONNECT);
    }

    private <T> ListenableFuture<T> sendRequestWithCertainForceConnect(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, ProxyServer proxyServer, boolean performConnectRequest) {
        NettyResponseFuture<T> newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, proxyServer, performConnectRequest);
        Channel channel = this.getOpenChannel(future, request, proxyServer, asyncHandler);
        return Channels.isChannelActive(channel) ? this.sendRequestWithOpenChannel(newFuture, asyncHandler, channel) : this.sendRequestWithNewChannel(request, proxyServer, newFuture, asyncHandler);
    }

    private <T> ListenableFuture<T> sendRequestThroughProxy(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, ProxyServer proxyServer) {
        Channel channel;
        NettyResponseFuture<T> newFuture = null;
        for (int i = 0; i < 3 && (channel = this.getOpenChannel(future, request, proxyServer, asyncHandler)) != null; ++i) {
            if (newFuture == null) {
                newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, proxyServer, false);
            }
            if (!Channels.isChannelActive(channel)) continue;
            return this.sendRequestWithOpenChannel(newFuture, asyncHandler, channel);
        }
        newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, proxyServer, true);
        return this.sendRequestWithNewChannel(request, proxyServer, newFuture, asyncHandler);
    }

    private <T> NettyResponseFuture<T> newNettyRequestAndResponseFuture(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> originalFuture, ProxyServer proxy, boolean performConnectRequest) {
        Realm realm;
        if (originalFuture != null) {
            realm = originalFuture.getRealm();
        } else {
            realm = request.getRealm();
            if (realm == null) {
                realm = this.config.getRealm();
            }
        }
        Realm proxyRealm = null;
        if (originalFuture != null) {
            proxyRealm = originalFuture.getProxyRealm();
        } else if (proxy != null) {
            proxyRealm = proxy.getRealm();
        }
        NettyRequest nettyRequest = this.requestFactory.newNettyRequest(request, performConnectRequest, proxy, realm, proxyRealm);
        if (originalFuture == null) {
            NettyResponseFuture<T> future = this.newNettyResponseFuture(request, asyncHandler, nettyRequest, proxy);
            future.setRealm(realm);
            future.setProxyRealm(proxyRealm);
            return future;
        }
        originalFuture.setNettyRequest(nettyRequest);
        originalFuture.setCurrentRequest(request);
        return originalFuture;
    }

    private Channel getOpenChannel(NettyResponseFuture<?> future, Request request, ProxyServer proxyServer, AsyncHandler<?> asyncHandler) {
        if (future != null && future.isReuseChannel() && Channels.isChannelActive(future.channel())) {
            return future.channel();
        }
        return this.pollPooledChannel(request, proxyServer, asyncHandler);
    }

    private <T> ListenableFuture<T> sendRequestWithOpenChannel(NettyResponseFuture<T> future, AsyncHandler<T> asyncHandler, Channel channel) {
        try {
            asyncHandler.onConnectionPooled(channel);
        }
        catch (Exception e) {
            LOGGER.error("onConnectionPooled crashed", e);
            this.abort(channel, future, e);
            return future;
        }
        SocketAddress channelRemoteAddress = channel.remoteAddress();
        if (channelRemoteAddress != null) {
            this.scheduleRequestTimeout(future, (InetSocketAddress)channelRemoteAddress);
        }
        future.setChannelState(ChannelState.POOLED);
        future.attachChannel(channel, false);
        if (LOGGER.isDebugEnabled()) {
            HttpRequest httpRequest = future.getNettyRequest().getHttpRequest();
            LOGGER.debug("Using open Channel {} for {} '{}'", channel, httpRequest.method(), httpRequest.uri());
        }
        Channels.setAttribute(channel, future);
        if (Channels.isChannelActive(channel)) {
            this.writeRequest(future, channel);
        } else {
            this.handleUnexpectedClosedChannel(channel, future);
        }
        return future;
    }

    private <T> ListenableFuture<T> sendRequestWithNewChannel(final Request request, final ProxyServer proxy, final NettyResponseFuture<T> future, final AsyncHandler<T> asyncHandler) {
        HttpHeaders customHeaders;
        HttpHeaders headers = future.getNettyRequest().getHttpRequest().headers();
        if (proxy != null && proxy.getCustomHeaders() != null && (customHeaders = proxy.getCustomHeaders().apply(request)) != null) {
            headers.add(customHeaders);
        }
        Realm realm = future.getRealm();
        Realm proxyRealm = future.getProxyRealm();
        this.requestFactory.addAuthorizationHeader(headers, AuthenticatorUtils.perConnectionAuthorizationHeader(request, proxy, realm));
        this.requestFactory.setProxyAuthorizationHeader(headers, AuthenticatorUtils.perConnectionProxyAuthorizationHeader(request, proxyRealm));
        future.setInAuth(realm != null && realm.isUsePreemptiveAuth() && realm.getScheme() != Realm.AuthScheme.NTLM);
        future.setInProxyAuth(proxyRealm != null && proxyRealm.isUsePreemptiveAuth() && proxyRealm.getScheme() != Realm.AuthScheme.NTLM);
        try {
            if (!this.channelManager.isOpen()) {
                throw PoolAlreadyClosedException.INSTANCE;
            }
            future.acquirePartitionLockLazily();
        }
        catch (Throwable t) {
            this.abort(null, future, MiscUtils.getCause(t));
            return future;
        }
        this.resolveAddresses(request, proxy, future, asyncHandler).addListener((GenericFutureListener<Future<List<InetSocketAddress>>>)new SimpleFutureListener<List<InetSocketAddress>>(){

            @Override
            protected void onSuccess(List<InetSocketAddress> addresses) {
                NettyConnectListener connectListener = new NettyConnectListener(future, NettyRequestSender.this, NettyRequestSender.this.channelManager, NettyRequestSender.this.connectionSemaphore);
                NettyChannelConnector connector = new NettyChannelConnector(request.getLocalAddress(), addresses, asyncHandler, NettyRequestSender.this.clientState);
                if (!future.isDone()) {
                    NettyRequestSender.this.channelManager.getBootstrap(request.getUri(), request.getNameResolver(), proxy).addListener(whenBootstrap -> {
                        if (whenBootstrap.isSuccess()) {
                            connector.connect((Bootstrap)whenBootstrap.get(), connectListener);
                        } else {
                            NettyRequestSender.this.abort(null, future, whenBootstrap.cause());
                        }
                    });
                }
            }

            @Override
            protected void onFailure(Throwable cause) {
                NettyRequestSender.this.abort(null, future, MiscUtils.getCause(cause));
            }
        });
        return future;
    }

    private <T> Future<List<InetSocketAddress>> resolveAddresses(Request request, ProxyServer proxy, NettyResponseFuture<T> future, AsyncHandler<T> asyncHandler) {
        Uri uri = request.getUri();
        Promise<List<InetSocketAddress>> promise = ImmediateEventExecutor.INSTANCE.newPromise();
        if (proxy != null && !proxy.isIgnoredForHost(uri.getHost()) && proxy.getProxyType().isHttp()) {
            int port = uri.isSecured() ? proxy.getSecuredPort() : proxy.getPort();
            InetSocketAddress unresolvedRemoteAddress = InetSocketAddress.createUnresolved(proxy.getHost(), port);
            this.scheduleRequestTimeout(future, unresolvedRemoteAddress);
            return RequestHostnameResolver.INSTANCE.resolve(request.getNameResolver(), unresolvedRemoteAddress, asyncHandler);
        }
        int port = uri.getExplicitPort();
        InetSocketAddress unresolvedRemoteAddress = InetSocketAddress.createUnresolved(uri.getHost(), port);
        this.scheduleRequestTimeout(future, unresolvedRemoteAddress);
        if (request.getAddress() != null) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(request.getAddress(), port);
            return promise.setSuccess(Collections.singletonList(inetSocketAddress));
        }
        return RequestHostnameResolver.INSTANCE.resolve(request.getNameResolver(), unresolvedRemoteAddress, asyncHandler);
    }

    private <T> NettyResponseFuture<T> newNettyResponseFuture(Request request, AsyncHandler<T> asyncHandler, NettyRequest nettyRequest, ProxyServer proxyServer) {
        NettyResponseFuture<T> future = new NettyResponseFuture<T>(request, asyncHandler, nettyRequest, this.config.getMaxRequestRetry(), request.getChannelPoolPartitioning(), this.connectionSemaphore, proxyServer);
        String expectHeader = request.getHeaders().get(HttpHeaderNames.EXPECT);
        if (HttpHeaderValues.CONTINUE.contentEqualsIgnoreCase(expectHeader)) {
            future.setDontWriteBodyBecauseExpectContinue(true);
        }
        return future;
    }

    public <T> void writeRequest(NettyResponseFuture<T> future, Channel channel) {
        NettyRequest nettyRequest = future.getNettyRequest();
        HttpRequest httpRequest = nettyRequest.getHttpRequest();
        AsyncHandler<T> asyncHandler = future.getAsyncHandler();
        if (!Channels.isChannelActive(channel)) {
            return;
        }
        try {
            boolean writeBody;
            if (asyncHandler instanceof TransferCompletionHandler) {
                this.configureTransferAdapter(asyncHandler, httpRequest);
            }
            boolean bl = writeBody = !future.isDontWriteBodyBecauseExpectContinue() && httpRequest.method() != HttpMethod.CONNECT && nettyRequest.getBody() != null;
            if (!future.isHeadersAlreadyWrittenOnContinue()) {
                try {
                    asyncHandler.onRequestSend(nettyRequest);
                }
                catch (Exception e) {
                    LOGGER.error("onRequestSend crashed", e);
                    this.abort(channel, future, e);
                    return;
                }
                if (writeBody) {
                    ChannelProgressivePromise promise = channel.newProgressivePromise();
                    ChannelFuture f = channel.write(httpRequest, promise);
                    f.addListener((GenericFutureListener)new WriteProgressListener(future, true, 0L));
                } else {
                    ChannelPromise promise = channel.newPromise();
                    ChannelFuture f = channel.writeAndFlush(httpRequest, promise);
                    f.addListener((GenericFutureListener)new WriteCompleteListener(future));
                }
            }
            if (writeBody) {
                nettyRequest.getBody().write(channel, future);
            }
            if (Channels.isChannelActive(channel)) {
                this.scheduleReadTimeout(future);
            }
        }
        catch (Exception e) {
            LOGGER.error("Can't write request", e);
            this.abort(channel, future, e);
        }
    }

    private void configureTransferAdapter(AsyncHandler<?> handler, HttpRequest httpRequest) {
        HttpHeaders h = new DefaultHttpHeaders().set(httpRequest.headers());
        ((TransferCompletionHandler)handler).headers(h);
    }

    private void scheduleRequestTimeout(NettyResponseFuture<?> nettyResponseFuture, InetSocketAddress originalRemoteAddress) {
        nettyResponseFuture.touch();
        TimeoutsHolder timeoutsHolder = new TimeoutsHolder(this.nettyTimer, nettyResponseFuture, this, this.config, originalRemoteAddress);
        nettyResponseFuture.setTimeoutsHolder(timeoutsHolder);
    }

    private void scheduleReadTimeout(NettyResponseFuture<?> nettyResponseFuture) {
        TimeoutsHolder timeoutsHolder = nettyResponseFuture.getTimeoutsHolder();
        if (timeoutsHolder != null) {
            nettyResponseFuture.touch();
            timeoutsHolder.startReadTimeout();
        }
    }

    public void abort(Channel channel, NettyResponseFuture<?> future, Throwable t) {
        if (channel != null) {
            Object attribute = Channels.getAttribute(channel);
            if (attribute instanceof StreamedResponsePublisher) {
                ((StreamedResponsePublisher)attribute).setError(t);
            }
            if (channel.isActive()) {
                this.channelManager.closeChannel(channel);
            }
        }
        if (!future.isDone()) {
            future.setChannelState(ChannelState.CLOSED);
            LOGGER.debug("Aborting Future {}\n", (Object)future);
            LOGGER.debug(t.getMessage(), t);
            future.abort(t);
        }
    }

    public void handleUnexpectedClosedChannel(Channel channel, NettyResponseFuture<?> future) {
        if (Channels.isActiveTokenSet(channel)) {
            if (future.isDone()) {
                this.channelManager.closeChannel(channel);
            } else if (future.incrementRetryAndCheck() && this.retry(future)) {
                future.pendingException = null;
            } else {
                this.abort(channel, future, future.pendingException != null ? future.pendingException : RemotelyClosedException.INSTANCE);
            }
        }
    }

    public boolean retry(NettyResponseFuture<?> future) {
        if (this.isClosed()) {
            return false;
        }
        if (future.isReplayPossible()) {
            future.setChannelState(ChannelState.RECONNECTED);
            LOGGER.debug("Trying to recover request {}\n", (Object)future.getNettyRequest().getHttpRequest());
            try {
                future.getAsyncHandler().onRetry();
            }
            catch (Exception e) {
                LOGGER.error("onRetry crashed", e);
                this.abort(future.channel(), future, e);
                return false;
            }
            try {
                this.sendNextRequest(future.getCurrentRequest(), future);
                return true;
            }
            catch (Exception e) {
                this.abort(future.channel(), future, e);
                return false;
            }
        }
        LOGGER.debug("Unable to recover future {}\n", (Object)future);
        return false;
    }

    public boolean applyIoExceptionFiltersAndReplayRequest(NettyResponseFuture<?> future, IOException e, Channel channel) {
        boolean replayed = false;
        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getCurrentRequest()).ioException(e).build();
        for (IOExceptionFilter asyncFilter : this.config.getIoExceptionFilters()) {
            try {
                fc = asyncFilter.filter(fc);
                Assertions.assertNotNull(fc, "filterContext");
            }
            catch (FilterException efe) {
                this.abort(channel, future, efe);
            }
        }
        if (fc.replayRequest() && future.incrementRetryAndCheck() && future.isReplayPossible()) {
            future.setKeepAlive(false);
            this.replayRequest(future, fc, channel);
            replayed = true;
        }
        return replayed;
    }

    public <T> void sendNextRequest(Request request, NettyResponseFuture<T> future) {
        this.sendRequest(request, future.getAsyncHandler(), future);
    }

    private void validateWebSocketRequest(Request request, AsyncHandler<?> asyncHandler) {
        Uri uri = request.getUri();
        boolean isWs = uri.isWebSocket();
        if (asyncHandler instanceof WebSocketUpgradeHandler) {
            if (!isWs) {
                throw new IllegalArgumentException("WebSocketUpgradeHandler but scheme isn't ws or wss: " + uri.getScheme());
            }
            if (!request.getMethod().equals(HttpConstants.Methods.GET) && !request.getMethod().equals(HttpConstants.Methods.CONNECT)) {
                throw new IllegalArgumentException("WebSocketUpgradeHandler but method isn't GET or CONNECT: " + request.getMethod());
            }
        } else if (isWs) {
            throw new IllegalArgumentException("No WebSocketUpgradeHandler but scheme is " + uri.getScheme());
        }
    }

    private Channel pollPooledChannel(Request request, ProxyServer proxy, AsyncHandler<?> asyncHandler) {
        try {
            asyncHandler.onConnectionPoolAttempt();
        }
        catch (Exception e) {
            LOGGER.error("onConnectionPoolAttempt crashed", e);
        }
        Uri uri = request.getUri();
        String virtualHost = request.getVirtualHost();
        Channel channel = this.channelManager.poll(uri, virtualHost, proxy, request.getChannelPoolPartitioning());
        if (channel != null) {
            LOGGER.debug("Using pooled Channel '{}' for '{}' to '{}'", channel, request.getMethod(), uri);
        }
        return channel;
    }

    public void replayRequest(NettyResponseFuture<?> future, FilterContext fc, Channel channel) {
        Request newRequest = fc.getRequest();
        future.setAsyncHandler(fc.getAsyncHandler());
        future.setChannelState(ChannelState.NEW);
        future.touch();
        LOGGER.debug("\n\nReplaying Request {}\n for Future {}\n", (Object)newRequest, (Object)future);
        try {
            future.getAsyncHandler().onRetry();
        }
        catch (Exception e) {
            LOGGER.error("onRetry crashed", e);
            this.abort(channel, future, e);
            return;
        }
        this.channelManager.drainChannelAndOffer(channel, future);
        this.sendNextRequest(newRequest, future);
    }

    public boolean isClosed() {
        return this.clientState.isClosed();
    }

    public void drainChannelAndExecuteNextRequest(Channel channel, NettyResponseFuture<?> future, final Request nextRequest) {
        Channels.setAttribute(channel, new OnLastHttpContentCallback(future){

            @Override
            public void call() {
                NettyRequestSender.this.sendNextRequest(nextRequest, this.future);
            }
        });
    }

    public void drainChannelAndExecuteNextRequest(Channel channel, NettyResponseFuture<?> future, final Request nextRequest, final Future<Channel> whenHandshaked) {
        Channels.setAttribute(channel, new OnLastHttpContentCallback(future){

            @Override
            public void call() {
                whenHandshaked.addListener(f -> {
                    if (f.isSuccess()) {
                        NettyRequestSender.this.sendNextRequest(nextRequest, this.future);
                    } else {
                        this.future.abort(f.cause());
                    }
                });
            }
        });
    }
}

