/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public interface ListenableFuture<V>
extends Future<V> {
    public void done();

    public void abort(Throwable var1);

    public void touch();

    public ListenableFuture<V> addListener(Runnable var1, Executor var2);

    public CompletableFuture<V> toCompletableFuture();

    public static class CompletedFailure<T>
    implements ListenableFuture<T> {
        private final ExecutionException e;

        public CompletedFailure(Throwable t) {
            this.e = new ExecutionException(t);
        }

        public CompletedFailure(String message, Throwable t) {
            this.e = new ExecutionException(message, t);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return true;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws ExecutionException {
            throw this.e;
        }

        @Override
        public T get(long timeout2, TimeUnit unit) throws ExecutionException {
            throw this.e;
        }

        @Override
        public void done() {
        }

        @Override
        public void abort(Throwable t) {
        }

        @Override
        public void touch() {
        }

        @Override
        public ListenableFuture<T> addListener(Runnable listener, Executor exec) {
            if (exec != null) {
                exec.execute(listener);
            } else {
                listener.run();
            }
            return this;
        }

        @Override
        public CompletableFuture<T> toCompletableFuture() {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(this.e);
            return future;
        }
    }
}

