/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.transport.security.spnego;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.binary.Base64;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SpnegoEngine {
    public static final int MAX_KDC_RETRIES = 10;
    public static final int RETRY_BACKOFF_MILLIS = 10;
    static final Oid GSS_KRB5_MECH_OID;
    static final Oid GSS_SPNEGO_MECH_OID;
    private static final String GSS_SPNEGO_MECH_OIDSTR = "1.3.6.1.5.5.2";
    private static final String GSS_KRB5_MECH_OIDSTR = "1.2.840.113554.1.2.2";
    private static final String NO_SERVICE_CREDS_MESSAGE = "no service creds";
    private static final Map<String, SpnegoEngine> instances;
    private final String authHost;
    private final Base64 base64codec;
    private final Semaphore semaphore;

    public SpnegoEngine(String authHost) {
        this.authHost = authHost;
        this.base64codec = new Base64(0);
        this.semaphore = new Semaphore(1);
    }

    public static SpnegoEngine instance(String authHost, String loginContextName) {
        String key = "";
        if (loginContextName != null) {
            key = key + loginContextName;
        }
        if (!instances.containsKey(key)) {
            instances.put(key, new SpnegoEngine(authHost));
        }
        return instances.get(key);
    }

    public String generateToken() throws GSSException {
        byte[] token = new byte[]{};
        try {
            token = this.generateGSSToken(GSS_SPNEGO_MECH_OID, "HTTP", this.authHost, false);
        }
        catch (GSSException e) {
            if (e.getMessage().toLowerCase().contains(NO_SERVICE_CREDS_MESSAGE)) {
                try {
                    if (this.semaphore.availablePermits() > 0) {
                        this.semaphore.acquire();
                        token = this.generateGSSToken(GSS_SPNEGO_MECH_OID, "HTTP", this.authHost, true);
                        this.semaphore.release();
                    } else {
                        int max_retries = 10;
                        long backoffMillis = 10L;
                        for (int i = 0; this.semaphore.availablePermits() == 0 && i < max_retries; ++i) {
                            long jitter = (long)(Math.random() * 3.0);
                            Thread.sleep(backoffMillis + jitter);
                            if (this.semaphore.availablePermits() <= 0 || (token = this.generateGSSToken(GSS_SPNEGO_MECH_OID, "HTTP", this.authHost, false)).length <= 0) continue;
                            break;
                        }
                        if (token.length == 0) {
                            throw new RuntimeException(String.format("Could not renew TGT after %s retries", max_retries));
                        }
                    }
                }
                catch (InterruptedException | LoginException ex) {
                    throw new RuntimeException("Could not login with KDC", e);
                }
            }
            throw e;
        }
        catch (LoginException e) {
            throw new RuntimeException("Could not login to KDC", e);
        }
        return new String(this.base64codec.encode(token));
    }

    protected byte[] generateGSSToken(Oid oid, String serviceName, String authHost, boolean loginRequired) throws GSSException, LoginException {
        byte[] inputBuff = new byte[0];
        if (inputBuff == null) {
            inputBuff = new byte[]{};
        }
        GSSManager manager = GSSManager.getInstance();
        String proxyServicePrincipal = serviceName + "@" + authHost;
        GSSName gssName = manager.createName(proxyServicePrincipal, GSSName.NT_HOSTBASED_SERVICE);
        GSSContext gssContext = manager.createContext(gssName.canonicalize(oid), oid, null, 0);
        gssContext.requestMutualAuth(true);
        if (loginRequired) {
            LoginContext loginContext = new LoginContext(proxyServicePrincipal, null, null, new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap())};
                }
            });
            loginContext.login();
        }
        return gssContext.initSecContext(inputBuff, 0, inputBuff.length);
    }

    static {
        instances = new HashMap<String, SpnegoEngine>();
        try {
            GSS_KRB5_MECH_OID = new Oid(GSS_KRB5_MECH_OIDSTR);
            GSS_SPNEGO_MECH_OID = new Oid(GSS_SPNEGO_MECH_OIDSTR);
        }
        catch (GSSException e) {
            throw new RuntimeException(e);
        }
    }
}

