/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.transport.security.proxy;

import com.mulesoft.transport.security.spnego.SpnegoEngine;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.ietf.jgss.GSSException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpnegoKerberosProxyAuthenticator
implements Authenticator {
    private final String proxyHost;

    public SpnegoKerberosProxyAuthenticator(@NotNull String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Override
    @Nullable
    public Request authenticate(Route route, Response response) {
        if (response.request().header("Proxy-Authorization") != null) {
            return null;
        }
        String token = null;
        try {
            token = SpnegoEngine.instance(this.proxyHost, "spnego-okhttp-" + this.hashCode()).generateToken();
        }
        catch (GSSException e) {
            throw new RuntimeException(String.format("Failed to generate proxy challenge auth token: %s", e.getMessage()), e);
        }
        String challengeToken = "Negotiate " + token;
        Request returnObj = response.request().newBuilder().header("Proxy-Authorization", challengeToken).build();
        return returnObj;
    }
}

