/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.transport.security.proxy;

import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class BasicProxyAuthenticator
implements Authenticator {
    private final String user;
    private final String password;

    public BasicProxyAuthenticator(String user, String password) {
        this.user = user;
        this.password = password;
    }

    @Override
    public Request authenticate(Route route, Response response) {
        if (response.request().header("Proxy-Authorization") != null) {
            return null;
        }
        String credential = Credentials.basic(this.user, this.password);
        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
    }
}

