/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.security.strategies;

import com.mulesoft.agent.security.model.AgentSecurityModel;
import com.mulesoft.agent.security.model.AgentSecurityProvider;
import com.mulesoft.agent.security.model.KeystoreType;
import com.mulesoft.agent.security.strategies.AgentCryptographyStrategy;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;

public class DefaultCryptographyStrategy
extends AgentCryptographyStrategy {
    private static final Logger LOGGER = LogManager.getLogger(DefaultCryptographyStrategy.class);

    public static DefaultCryptographyStrategy newInstance() {
        return new DefaultCryptographyStrategy();
    }

    @Override
    public KeystoreType getKeystoreType() {
        return KeystoreType.JKS;
    }

    @Override
    public KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        LOGGER.debug("Renew certificate - Generating Key Pair with Default Strategy");
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(this.getKeyGenerationAlgorithm().name());
        LOGGER.debug("Renew certificate - Generating Key Pair - Got instance");
        keyGen.initialize(this.getKeySize(), new SecureRandom());
        LOGGER.debug("Renew certificate - Generating Key Pair - KeyGen initialization");
        return keyGen.generateKeyPair();
    }

    @Override
    public ContentSigner buildContentSigner(PrivateKey privateKey) throws OperatorCreationException, IOException {
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(this.getSignatureAlgorithm());
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        AsymmetricKeyParameter foo = PrivateKeyFactory.createKey(privateKey.getEncoded());
        return new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(foo);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void loadSecurityProvider() {
    }

    @Override
    public AgentSecurityProvider getProvider() {
        return AgentSecurityProvider.DEFAULT;
    }

    @Override
    public CertificateFactory getCertificateFactoryInstance() throws CertificateException {
        return CertificateFactory.getInstance(this.getPublicKeyFormat());
    }

    @Override
    public AgentSecurityModel getSecurityModel() {
        return AgentSecurityModel.NONE;
    }
}

