/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.security.strategies;

import com.mulesoft.agent.security.model.AgentSecurityProvider;
import com.mulesoft.agent.security.strategies.BouncyCastleCryptographyStrategy;
import com.mulesoft.agent.security.strategies.CryptographyStrategy;
import com.mulesoft.agent.security.strategies.DefaultCryptographyStrategy;
import com.mulesoft.agent.security.strategies.FipsCryptographyStrategy;

public class CryptographyStrategyBuilder {
    public static final String MULE_SECURITY_PROVIDER_PROPERTY = "mule.security.provider";
    private boolean fipsEnabled;

    private CryptographyStrategyBuilder(boolean enableFips) {
        this.fipsEnabled = enableFips;
    }

    public static CryptographyStrategyBuilder newInstance(boolean enableFips) {
        return new CryptographyStrategyBuilder(enableFips);
    }

    public CryptographyStrategy build() {
        if (this.fipsEnabled) {
            return FipsCryptographyStrategy.newInstance();
        }
        if (AgentSecurityProvider.BC.name().equals(System.getProperty(MULE_SECURITY_PROVIDER_PROPERTY))) {
            return BouncyCastleCryptographyStrategy.newInstance();
        }
        return DefaultCryptographyStrategy.newInstance();
    }

    public boolean isFipsEnabled() {
        return this.fipsEnabled;
    }
}

