/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.security.strategies;

import com.mulesoft.agent.security.model.AgentSecurityModel;
import com.mulesoft.agent.security.model.AgentSecurityProvider;
import com.mulesoft.agent.security.model.CertificateType;
import com.mulesoft.agent.security.model.KeystoreType;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public interface CryptographyStrategy {
    public KeystoreType getKeystoreType();

    public CertificateType getCertificateType();

    public String getPublicKeyFormat();

    public KeyStore getKeystoreInstance() throws KeyStoreException;

    public CertificateFactory getCertificateFactoryInstance() throws CertificateException, NoSuchProviderException;

    public KeyPair generateKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException;

    public ContentSigner buildContentSigner(PrivateKey var1) throws OperatorCreationException, IOException;

    public PKCS10CertificationRequest buildAgentCertificateSigningRequest(PublicKey var1, ContentSigner var2);

    public String buildAgentCertificateSigningRequestAsString(PublicKey var1, ContentSigner var2) throws IOException;

    public void initialize();

    public void loadSecurityProvider() throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchAlgorithmException;

    public AgentSecurityProvider getProvider();

    public AgentSecurityModel getSecurityModel();

    public int getKeySize();
}

