/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.security;

import com.mulesoft.agent.security.model.AgentSecurityProvider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class CertificateAuthority {
    private static final int CERTIFICATE_VALIDITY = 8;
    private static final Logger LOGGER = LogManager.getLogger();
    private final PrivateKey caPrivate;
    private X500Principal x500Principal;

    public CertificateAuthority(PrivateKey caPrivate, X500Principal principal) {
        this.caPrivate = caPrivate;
        this.x500Principal = principal;
    }

    public java.security.cert.Certificate sign(InputStream csr) throws OperatorCreationException, NoSuchAlgorithmException, IOException, CertificateException, SignatureException, NoSuchProviderException, InvalidKeyException {
        return this.sign(this.convertPemToPKCS10CertificationRequest(csr));
    }

    public java.security.cert.Certificate sign(PKCS10CertificationRequest inputCSR) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, IOException, OperatorCreationException, CertificateException {
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA1withRSA");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        AsymmetricKeyParameter foo = PrivateKeyFactory.createKey(this.caPrivate.getEncoded());
        SubjectPublicKeyInfo keyInfo = inputCSR.getSubjectPublicKeyInfo();
        Calendar cal = Calendar.getInstance();
        Date notBefore = new Date(cal.getTimeInMillis());
        cal.add(1, 8);
        X509v3CertificateBuilder myCertificateGenerator = new X509v3CertificateBuilder(this.toX500Name(this.x500Principal), new BigInteger(String.valueOf(System.currentTimeMillis())), notBefore, cal.getTime(), inputCSR.getSubject(), keyInfo);
        ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(foo);
        X509CertificateHolder holder = myCertificateGenerator.build(sigGen);
        Certificate eeX509CertificateStructure = holder.toASN1Structure();
        CertificateFactory cf = CertificateFactory.getInstance("X.509", AgentSecurityProvider.BC.name());
        ByteArrayInputStream is1 = new ByteArrayInputStream(eeX509CertificateStructure.getEncoded());
        java.security.cert.Certificate theCert = cf.generateCertificate(is1);
        ((InputStream)is1).close();
        return theCert;
    }

    private PKCS10CertificationRequest convertPemToPKCS10CertificationRequest(InputStream pemStream) {
        Security.addProvider(new BouncyCastleProvider());
        PKCS10CertificationRequest csr = null;
        BufferedReader pemReader = new BufferedReader(new InputStreamReader(pemStream));
        PEMParser pemParser = new PEMParser(pemReader);
        try {
            Object parsedObj = pemParser.readObject();
            if (parsedObj instanceof PKCS10CertificationRequest) {
                csr = (PKCS10CertificationRequest)parsedObj;
            }
        }
        catch (IOException ex) {
            LOGGER.error("IOException, convertPemToPublicKey", (Throwable)ex);
        }
        return csr;
    }

    private X500Name toX500Name(X500Principal principal) {
        byte[] bytes = principal.getEncoded();
        return X500Name.getInstance(bytes);
    }
}

