/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.security;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public class CSRGenerator {
    private static final String FORMAT = "CN=%s, OU=%s, O=%s, L=%s, ST=%s, C=%s";
    private static final String CSR_SIGNATURE_ALGORITHM = "SHA256WITHRSA";
    private PublicKey publicKey;
    private PrivateKey privateKey;

    public CSRGenerator(KeyPair keyPair) {
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
    }

    public PKCS10CertificationRequest generatePKCS10(String cn, String ou, String o, String l, String s, String c) throws Exception {
        X500Principal principal = new X500Principal(String.format(FORMAT, cn, ou, o, l, s, c));
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(CSR_SIGNATURE_ALGORITHM);
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        JcaPKCS10CertificationRequestBuilder builder = new JcaPKCS10CertificationRequestBuilder(principal, this.publicKey);
        AsymmetricKeyParameter foo = PrivateKeyFactory.createKey(this.privateKey.getEncoded());
        ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(foo);
        return builder.build(sigGen);
    }
}

