/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.widget;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mule.tooling.ui.dfl.contribution.editor.script.ToogleControlManager;

public class DualCodePreviewContainer
extends SashForm {
    private boolean previewEnabled = false;
    private int sourceControlIndex = 0;
    private int previewControlIndex = 1;
    private ToogleControlManager toogleControlManager;

    public DualCodePreviewContainer(Composite parent, ToogleControlManager toogleControlManager, int style) {
        this(parent, style, 0, 1);
        this.toogleControlManager = toogleControlManager;
    }

    public DualCodePreviewContainer(Composite parent, int style, int sourceControlIndex, int previewControlIndex) {
        super(parent, style);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                DualCodePreviewContainer.this.updateLayout();
            }
        });
    }

    public void setPreviewEnabled(boolean value) {
        if (value != this.previewEnabled) {
            this.previewEnabled = value;
            this.updateLayout();
        }
    }

    public boolean isPreviewEnabled() {
        return this.previewEnabled;
    }

    protected void updateLayout() {
        Rectangle rect = this.getClientArea();
        if (rect.width > 500) {
            this.showSourceAndPreview();
        } else if (rect.height > 400) {
            this.showSourceAndPreview();
        } else {
            this.showSourceOrPreview();
        }
        if (rect.height + 100 > rect.width) {
            this.setOrientation(512);
        } else {
            this.setOrientation(256);
        }
    }

    public void showSourceOrPreview() {
        this.setMaximizedControl(this.isPreviewEnabled() ? this.getPreviewControl() : this.getSourceControl());
    }

    public void showSourceAndPreview() {
        this.setMaximizedControl(this.isPreviewEnabled() ? null : this.getSourceControl());
    }

    private Control getSourceControl() {
        Control[] children = this.getChildren();
        return children != null && children.length - 1 > this.sourceControlIndex ? children[this.sourceControlIndex] : null;
    }

    public ToogleControlManager getToogleControlManager() {
        return this.toogleControlManager;
    }

    public void setToogleControlManager(ToogleControlManager toogleControlManager) {
        this.toogleControlManager = toogleControlManager;
    }

    private Control getPreviewControl() {
        Control[] children = this.getChildren();
        return children != null && children.length - 1 > this.previewControlIndex ? children[this.previewControlIndex] : null;
    }

    public void dispose() {
        super.dispose();
    }
}

