/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.validation;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentTextNode;
import java.util.List;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.mule.tooling.client.ToolingPropagationInfo;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.core.validation.ValidationConstants;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.IComponentValidator;
import org.mule.weave.v2.editor.ValidationMessages;

public class DFLValidator
implements IComponentValidator {
    public static final String ERROR_MESSAGE = "There are errors in the DataWeave script";
    public static final String RESOURCE = "resource";

    public Message validateComponent(DomainEditingModelObject pNode) {
        Message result = ValidationConstants.MESSAGE_OK;
        if (pNode.getTextNode() == null && pNode.getXMLAttributeValue(RESOURCE) != null) {
            return result;
        }
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        if (muleProject != null) {
            ValidationMessages validationResult;
            DataWeaveLanguageService service = DataWeaveLanguageService.getInstance((IMuleProject)muleProject);
            IDocumentTextNode textNode = pNode.getTextNode();
            String textToValidate = "";
            if (textNode != null && textNode.getText() != null && !textNode.toString().trim().isEmpty()) {
                String string = textToValidate = ExpressionUtils.isExpression((String)textNode.getText()) ? ExpressionUtils.getExpressionValue((String)textNode.getText()) : textNode.getText();
            }
            if ((validationResult = service.validateScript((IDocument)new Document(textToValidate), (IDataSenseProvider)IDataSenseProvider.create((PropagationInfo)ToolingPropagationInfo.PropagationInfoBuilder.DEFAULT), true)).errorMessage().length > 0) {
                result = MessageBuilder.newErrorMessage((String)validationResult.errorMessage()[0].message().message()).build();
            }
        }
        return result;
    }

    public Message validateComponentGUI(IMessageFlowNode node, List<IFieldEditor> editors) {
        return ValidationConstants.MESSAGE_OK;
    }
}

