/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.ImportDirective;
import org.mule.tooling.dfl.ui.datasense.DataSenseHolder;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.datasense.WeaveDataSenseProvider;
import org.mule.tooling.dfl.ui.embedded.editor.DFLTextViewerUndoManager;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.ui.dfl.contribution.editor.script.ApplyFunctionToExpressionWork;
import org.mule.tooling.ui.dfl.contribution.editor.script.FunctionManagerComposite;
import org.mule.tooling.ui.dfl.contribution.editor.script.FunctionManagerPresenter;
import org.mule.tooling.ui.dfl.contribution.editor.script.FunctionParametersComposite;
import org.mule.tooling.ui.dfl.contribution.editor.script.FunctionParametersPresenter;
import org.mule.tooling.ui.dfl.contribution.editor.script.SelectDocumentExpression;
import org.mule.tooling.ui.widgets.dialog.ISimpleDialogEditorPresenter;
import org.mule.tooling.ui.widgets.dialog.SimpleEditorDialog;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.weave.v2.editor.FunctionDefinition;
import org.mule.weave.v2.editor.ImplicitInput;
import org.mule.weave.v2.ts.AnyType;
import org.mule.weave.v2.ts.WeaveType;

public class ApplyFunctionToSelectedCodeAction
extends Action
implements ISourceViewerAware {
    private ISourceViewer sourceViewer;

    public ApplyFunctionToSelectedCodeAction() {
        this.setText("Apply Function");
        this.setActionDefinitionId("org.mule.tooling.ui.dfl.contribution.applyFunctionCommand");
    }

    public boolean isEnabled() {
        return this.sourceViewer != null;
    }

    public void runWithEvent(Event event) {
        IMuleProject project = MuleCorePlugin.getDesignContext().getMuleProject();
        this.showFunctionsManager(project);
    }

    private void showFunctionsManager(IMuleProject project) {
        FunctionManagerPresenter controller = new FunctionManagerPresenter(project, (WeaveType)new AnyType());
        SimpleEditorDialog dialog = WidgetUtils.createSimpleEditorDialog(FunctionManagerComposite.class, (ISimpleDialogEditorPresenter)controller, (String)"Insert", (String)"Cancel");
        dialog.setSize(700, 600);
        dialog.setTitle("Functions");
        if (dialog.open() == 0) {
            this.showParametersEditor(project, controller);
        }
    }

    private void showParametersEditor(IMuleProject project, FunctionManagerPresenter controller) {
        XtextDocument document = (XtextDocument)this.sourceViewer.getDocument();
        final TextSelection textSelection = (TextSelection)this.sourceViewer.getSelectionProvider().getSelection();
        Optional<FunctionDefinition> selectedFunction = controller.getSelectedFunction();
        if (selectedFunction.isPresent()) {
            FunctionDefinition functionDefinition = selectedFunction.get();
            if (functionDefinition.params().length == 0) {
                this.applyFunctionToSelectedCode(document, textSelection, functionDefinition);
            } else {
                Expression selectedExpression = (Expression)document.readOnly((IUnitOfWork)new IUnitOfWork<Expression, XtextResource>(){

                    public Expression exec(XtextResource state) throws Exception {
                        EObject expression;
                        IParseResult parseResult = state.getParseResult();
                        ILeafNode selectedNode = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)textSelection.getOffset());
                        while (selectedNode.getLength() < textSelection.getLength() && selectedNode.getParent().getOffset() == textSelection.getOffset()) {
                            selectedNode = selectedNode.getParent();
                        }
                        if (selectedNode != null && (expression = NodeModelUtils.findActualSemanticObjectFor((INode)selectedNode)) instanceof Expression) {
                            return (Expression)expression;
                        }
                        return null;
                    }
                });
                FunctionParametersPresenter functionParametersPresenter = this.buildFunctionParametersPresenter(project, document, selectedExpression, functionDefinition);
                SimpleEditorDialog<FunctionParametersComposite> paramsEditor = this.buildParametersEditor(functionDefinition, functionParametersPresenter);
                int open = paramsEditor.open();
                if (open == 0) {
                    this.applyFunctionToSelectedCode(document, textSelection, functionDefinition, functionParametersPresenter.getExpressions(), functionParametersPresenter.getImports());
                } else if (open == 14) {
                    this.showFunctionsManager(project);
                }
            }
        }
    }

    private FunctionParametersPresenter buildFunctionParametersPresenter(IMuleProject project, XtextDocument document, Expression selectedExpression, FunctionDefinition functionDefinition) {
        Document documentModel;
        IDataSenseProvider dataSense = DataSenseHolder.getCurrentDataSenseProvider((String)document.getResourceURI().toString());
        Optional<Expression> expression = Optional.ofNullable(selectedExpression);
        String code = "";
        if (expression.isPresent() && (documentModel = (Document)document.readOnly((IUnitOfWork)new SelectDocumentExpression())) != null) {
            Expression value = expression.get();
            code = ScaffoldingHelper.toExpressionAssignmentString((Document)documentModel, (Expression)value);
            ICompositeNode node = NodeModelUtils.getNode((EObject)value);
            if (node != null) {
                int offset = node.getOffset();
                ImplicitInput availableContext = DataWeaveLanguageService.getInstance((IMuleProject)project).availableContext(document.getResourceURI(), (IXtextDocument)document, dataSense, offset);
                dataSense = new WeaveDataSenseProvider(availableContext, (WeaveType)new AnyType());
            }
        }
        return new FunctionParametersPresenter(functionDefinition, dataSense, project, code);
    }

    private SimpleEditorDialog<FunctionParametersComposite> buildParametersEditor(FunctionDefinition functionDefinition, FunctionParametersPresenter functionParametersPresenter) {
        SimpleEditorDialog paramsEditor = WidgetUtils.createSimpleEditorDialog(FunctionParametersComposite.class, (ISimpleDialogEditorPresenter)functionParametersPresenter, (String)"Finish", (String)"Cancel");
        paramsEditor.setBackButton("Back To Functions");
        paramsEditor.setSize(700, 600);
        paramsEditor.setTitle("Parameters for: " + functionDefinition.nameIdentifier().localName().name());
        return paramsEditor;
    }

    private void applyFunctionToSelectedCode(XtextDocument document, TextSelection textSelection, FunctionDefinition functionDefinition) {
        this.applyFunctionToSelectedCode(document, textSelection, functionDefinition, new ArrayList<Expression>(), new ArrayList<ImportDirective>());
    }

    private void applyFunctionToSelectedCode(XtextDocument document, TextSelection textSelection, FunctionDefinition functionDefinition, List<Expression> expressions, List<ImportDirective> imports) {
        XtextSourceViewer xtextSourceViewer = (XtextSourceViewer)this.sourceViewer;
        DFLTextViewerUndoManager textViewerUndoManager = (DFLTextViewerUndoManager)xtextSourceViewer.getUndoManager();
        textViewerUndoManager.beginCrossCompoundChange();
        document.modify((IUnitOfWork)new ApplyFunctionToExpressionWork(functionDefinition, expressions, textSelection.getOffset(), textSelection.getLength(), imports));
        textViewerUndoManager.endCrossCompoundChange();
        xtextSourceViewer.doOperation(15);
    }

    public void setSourceViewer(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }
}

