/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.output;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.sample.IMetadataEventSelector;
import org.mule.tooling.metadata.sample.MetadataSampleService;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;

public class SampleDataValidator {
    private EditorContext context;

    public SampleDataValidator(EditorContext context) {
        this.context = context;
    }

    public boolean areRequiredSampleDataDefined(List<IMetadataEventSelector> requiredVars) {
        if (requiredVars.isEmpty()) {
            return true;
        }
        MetadataSampleService service = MetadataSampleService.getInstance((IMuleProject)this.context.getProject());
        for (IMetadataEventSelector metadataEventSelector : requiredVars) {
            boolean hasSampleDefined = service.hasSampleDefined(this.context.getNode(), metadataEventSelector, this.context.getInputMetadataProvider().getMetadata());
            if (hasSampleDefined) continue;
            return false;
        }
        return true;
    }

    public List<IMetadataEventSelector> calculateRequiredSamples(List<IMetadataEventSelector> requiredVars) {
        MetadataSampleService service = MetadataSampleService.getInstance((IMuleProject)this.context.getProject());
        return requiredVars.stream().filter(selector -> !service.hasSampleDefined(this.context.getNode(), selector, this.context.getInputMetadataProvider().getMetadata())).collect(Collectors.toList());
    }
}

