/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.output;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.mule.tooling.dfl.ui.DFLEditor;
import org.mule.tooling.dfl.ui.module.IOutputViewer;
import org.mule.tooling.dfl.ui.module.IWeaveUIModule;
import org.mule.tooling.dfl.ui.module.WeaveUIModuleManager;
import org.mule.tooling.metadata.sample.IMetadataEventSelector;
import org.mule.tooling.ui.dfl.contribution.editor.script.DataWeaveEditor;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.ToogleActionType;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.ToggleModeEvent;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.InputViewer;
import org.mule.tooling.ui.dfl.contribution.editor.script.output.ReadVariableReferencesUnitOfWork;
import org.mule.tooling.ui.dfl.contribution.editor.script.output.SampleDataValidator;
import org.mule.tooling.utils.Pair;
import org.mule.tooling.utils.eventbus.IEvent;

public class OutputPreviewEditor
extends Composite {
    private Composite previewViewerWrapper;
    private Map<String, Pair<IOutputViewer, Control>> viewers = new HashMap<String, Pair<IOutputViewer, Control>>();
    private StackLayout previewWrapperLayout;
    private EditorContext context;
    private InputViewer inputViewer;
    private DataWeaveEditor editor;
    private SampleDataValidator sampleDataValidator;
    private CLabel emptyPreviewMessage;
    private CLabel customPreviewMessage;
    private Composite emptyPreviewCreateSampleData;
    private List<IMetadataEventSelector> requiredVars;
    private XtextDocument document;

    public OutputPreviewEditor(Composite parent, EditorContext context, InputViewer inputViewer, DataWeaveEditor editor, SampleDataValidator sampleDataValidator, XtextDocument document) {
        super(parent, 0);
        this.context = context;
        this.inputViewer = inputViewer;
        this.editor = editor;
        this.sampleDataValidator = sampleDataValidator;
        this.document = document;
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo((Composite)this);
        parent.setBackground(DFLEditor.BACKGROUND_COLOR);
        parent.setBackgroundMode(2);
        this.createControls(this);
    }

    private void createControls(Composite parent) {
        Label separator = new Label(parent, -2);
        GridDataFactory.fillDefaults().span(1, 2).grab(false, true).applyTo((Control)separator);
        Composite wrapper = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(wrapper);
        this.previewViewerWrapper = new Composite(wrapper, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.previewViewerWrapper);
        this.previewWrapperLayout = new StackLayout();
        this.previewViewerWrapper.setLayout((Layout)this.previewWrapperLayout);
        this.clearState();
    }

    public void updateFeedback(String mimeType, String output) {
        if (this.isDisposed()) {
            return;
        }
        if (this.viewers.containsKey(mimeType)) {
            Pair<IOutputViewer, Control> pair = this.viewers.get(mimeType);
            this.show(output, pair);
        } else {
            IWeaveUIModule module = WeaveUIModuleManager.getModuleByContentType((String)mimeType);
            IOutputViewer outputPreviewViewer = module.getOutputPreviewViewer();
            Control editorControl = outputPreviewViewer.createControl(this.previewViewerWrapper);
            Pair pair = new Pair((Object)outputPreviewViewer, (Object)editorControl);
            this.viewers.put(mimeType, (Pair<IOutputViewer, Control>)pair);
            this.show(output, (Pair<IOutputViewer, Control>)pair);
        }
    }

    private void show(String output, Pair<IOutputViewer, Control> pair) {
        this.previewWrapperLayout.topControl = (Control)pair.getRight();
        this.previewViewerWrapper.layout();
        ((IOutputViewer)pair.getLeft()).updateInput(output);
    }

    private void clearState() {
        List<IMetadataEventSelector> requiredVars = this.fetchRequiredVariables();
        if (this.sampleDataValidator.areRequiredSampleDataDefined(requiredVars)) {
            this.showEmptyMessage();
        } else {
            this.showEmptyPreviewLink(requiredVars);
        }
    }

    private List<IMetadataEventSelector> fetchRequiredVariables() {
        ReadVariableReferencesUnitOfWork work = new ReadVariableReferencesUnitOfWork();
        this.document.readOnly((IUnitOfWork)work);
        List<IMetadataEventSelector> variables = work.getReferencedElements();
        return variables;
    }

    public void showEmptyPreviewLink(List<IMetadataEventSelector> requiredVars2) {
        this.setRequiredVariables(requiredVars2);
        if (this.emptyPreviewCreateSampleData == null) {
            this.createEmptyPreviewLink();
        }
        this.previewWrapperLayout.topControl = this.emptyPreviewCreateSampleData;
        if (this.previewViewerWrapper != null) {
            this.previewViewerWrapper.layout(true, true);
        }
    }

    private void setRequiredVariables(List<IMetadataEventSelector> requiredVars2) {
        this.requiredVars = requiredVars2;
    }

    public void showEmptyMessage() {
        if (this.emptyPreviewMessage == null) {
            this.createEmptyPreviewMessage();
        }
        this.previewWrapperLayout.topControl = this.emptyPreviewMessage;
        this.previewViewerWrapper.layout(true, true);
    }

    public void showPreviewMessage(String message) {
        if (this.customPreviewMessage == null) {
            this.createCustomPreviewMessage();
        }
        this.customPreviewMessage.setText(message);
        this.previewWrapperLayout.topControl = this.customPreviewMessage;
        this.previewViewerWrapper.layout(true, true);
    }

    private void createEmptyPreviewLink() {
        this.emptyPreviewCreateSampleData = new Composite(this.previewViewerWrapper, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)this.emptyPreviewCreateSampleData);
        GridLayoutFactory.fillDefaults().applyTo(this.emptyPreviewCreateSampleData);
        Link link = new Link(this.emptyPreviewCreateSampleData, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)link);
        link.setForeground(DFLEditor.TITLE_COLOR);
        link.setText("<a>Create required sample data to execute preview</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (OutputPreviewEditor.this.editor.getCurrentToogleType().equals((Object)ToogleActionType.SOURCE_VIEW)) {
                    OutputPreviewEditor.this.context.getEventBus().fireEvent((IEvent)new ToggleModeEvent(ToogleActionType.MAPPING_VIEW));
                }
                OutputPreviewEditor.this.inputViewer.createSample(OutputPreviewEditor.this.getRequiredVariables());
            }
        });
    }

    public List<IMetadataEventSelector> getRequiredVariables() {
        return this.requiredVars;
    }

    private void createEmptyPreviewMessage() {
        this.emptyPreviewMessage = new CLabel(this.previewViewerWrapper, 0x1000000);
        this.emptyPreviewMessage.setText("There is no preview yet to be shown.");
    }

    private void createCustomPreviewMessage() {
        this.customPreviewMessage = new CLabel(this.previewViewerWrapper, 0x1000000);
    }
}

