/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.output;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditor;
import org.mule.tooling.messageflow.events.IMetadataPropagationFinishedListener;
import org.mule.tooling.messageflow.events.PropagationEventTypes;
import org.mule.tooling.metadata.sample.IMetadataEventSelector;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.MessageTransformerEventTypes;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.script.output.DFLEngineResultCallback;
import org.mule.tooling.ui.dfl.contribution.editor.script.output.DFLPreviewJob;
import org.mule.tooling.ui.dfl.contribution.editor.script.output.OutputPreviewEditor;
import org.mule.tooling.ui.dfl.contribution.editor.script.output.ReadVariableReferencesUnitOfWork;
import org.mule.tooling.ui.dfl.contribution.editor.script.output.SampleDataValidator;
import org.mule.tooling.ui.dfl.contribution.widget.DualCodePreviewContainer;
import org.mule.tooling.ui.widgets.errors.ErrorManager;
import org.mule.tooling.ui.widgets.listener.IdleDocumentEventListener;
import org.mule.tooling.utils.FutureCallbackAdapter;
import org.mule.tooling.utils.eventbus.EventRegistrationHandler;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.tooling.weave.engine.output.IDFLEngineCallback;

public class OutputPreviewController {
    private SettableFuture<IXtextDocument> documentRef;
    private EditorContext context;
    private DFLPreviewJob dflPreviewJob;
    private IDFLEngineCallback callback;
    private IMappingModel transformerModel;
    private DualCodePreviewContainer dualContainer;
    private ErrorManager<Document, Issue> errorManager;
    private SampleDataValidator sampleDataValidator;
    private OutputPreviewEditor editor;

    public OutputPreviewController(EditorContext context, SettableFuture<IXtextDocument> documentRef, IMappingModel transformerHandler, DualCodePreviewContainer dualContainer, ErrorManager<Document, Issue> errorManager, SampleDataValidator sampleDataValidator) {
        this.context = context;
        this.documentRef = documentRef;
        this.dualContainer = dualContainer;
        this.transformerModel = transformerHandler;
        this.errorManager = errorManager;
        this.sampleDataValidator = sampleDataValidator;
    }

    public List<EventRegistrationHandler> handle(final OutputPreviewEditor editor, DFLEmbeddedEditor transformerEditor) {
        this.editor = editor;
        this.callback = new DFLEngineResultCallback(editor, transformerEditor, this.errorManager, this.context);
        ArrayList handlers = Lists.newArrayList();
        handlers.add(this.context.getEventBus().registerUIThreadListener(MessageTransformerEventTypes.ON_CLICK_PREVIEW, () -> {
            boolean previewEnabled = this.dualContainer.isPreviewEnabled();
            if (previewEnabled) {
                AnalyticsRecordsFactory.single((String)Events.DW_PREVIEW_ON).track();
            } else {
                AnalyticsRecordsFactory.single((String)Events.DW_PREVIEW_OFF).track();
            }
            this.runPreview(this.callback, previewEnabled);
        }));
        handlers.add(this.context.getEventBus().registerUIThreadListener(MessageTransformerEventTypes.ON_SAMPLE_DATA_MODIFED, (kind, content, selector) -> this.runPreview(this.callback, this.dualContainer.isPreviewEnabled())));
        handlers.add(MuleCorePlugin.getEventBus().registerUIThreadListener(PropagationEventTypes.ON_METADATA_PROPAGATION_FINISHED, (IEventHandler)((IMetadataPropagationFinishedListener)propagationInfo -> this.runPreview(this.callback, this.dualContainer.isPreviewEnabled()))));
        Futures.addCallback(this.documentRef, (FutureCallback)new FutureCallbackAdapter<IXtextDocument>(){

            public void onSuccess(IXtextDocument result) {
                IXtextDocument document = (IXtextDocument)Futures.getUnchecked(OutputPreviewController.this.documentRef);
                long previewDelay = DFLExtendedActivator.getInstance().getPreferenceStore().getLong("dfl.preview.delay");
                IdleDocumentEventListener documentEventListener = new IdleDocumentEventListener(previewDelay, (IDocumentListener)new PreviewRunnerDocumentListener(OutputPreviewController.this.callback), (Control)editor);
                document.addDocumentListener((IDocumentListener)documentEventListener);
                editor.addDisposeListener(event -> document.removeDocumentListener((IDocumentListener)documentEventListener));
                OutputPreviewController.this.runPreview(OutputPreviewController.this.callback, OutputPreviewController.this.dualContainer.isPreviewEnabled());
            }
        }, (Executor)MoreExecutors.directExecutor());
        return handlers;
    }

    private void runPreview(IDFLEngineCallback callback, boolean isPreviewEnable) {
        try {
            if (isPreviewEnable) {
                List<IMetadataEventSelector> requiredVariables = this.fetchRequiredVariables();
                if (this.sampleDataValidator.areRequiredSampleDataDefined(requiredVariables)) {
                    if (this.dflPreviewJob == null) {
                        this.dflPreviewJob = new DFLPreviewJob("Running Preview...", callback, this.documentRef, this.context.getInputMetadataProvider(), this.transformerModel, this.context.getProject(), this.context.getEventBus());
                    }
                    this.dflPreviewJob.schedule();
                } else {
                    this.editor.showEmptyPreviewLink(requiredVariables);
                }
            } else {
                callback.clearWarningAndAnnotations();
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Error running preview", (Throwable)e);
        }
    }

    private List<IMetadataEventSelector> fetchRequiredVariables() {
        ReadVariableReferencesUnitOfWork work = new ReadVariableReferencesUnitOfWork();
        ((IXtextDocument)Futures.getUnchecked(this.documentRef)).readOnly((IUnitOfWork)work);
        return work.getReferencedElements();
    }

    private final class PreviewRunnerDocumentListener
    implements IDocumentListener {
        private IDFLEngineCallback callback;

        private PreviewRunnerDocumentListener(IDFLEngineCallback callback) {
            this.callback = callback;
        }

        public void documentChanged(DocumentEvent event) {
            OutputPreviewController.this.runPreview(this.callback, OutputPreviewController.this.dualContainer.isPreviewEnabled());
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    }
}

