/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.output;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.mule.tooling.dfl.dFL.DotSelector;
import org.mule.tooling.dfl.dFL.VariableReference;
import org.mule.tooling.dfl.ui.graphical.code2view.CodeToViewAction;
import org.mule.tooling.dfl.ui.graphical.code2view.MappingContext;
import org.mule.tooling.dfl.ui.graphical.model.GraphicalEvaluationContext;
import org.mule.tooling.dfl.ui.graphical.references.CodeReference;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.metadata.sample.AttributesEventSelector;
import org.mule.tooling.metadata.sample.IMetadataEventSelector;
import org.mule.tooling.metadata.sample.PayloadEventSelector;
import org.mule.tooling.metadata.sample.VariableEventSelector;

public class GetVariableReferencesAction
extends CodeToViewAction {
    private Map<String, IMetadataEventSelector> referencedElements = new HashMap<String, IMetadataEventSelector>();

    public GetVariableReferencesAction(MappingContext context) {
        super(context);
    }

    public Void caseDotSelector(DotSelector object) {
        CodeReference reference = CodeReference.of((GraphicalEvaluationContext)this.getContext(), (EObject)object);
        this.addReference(reference);
        return super.caseDotSelector(object);
    }

    public Void caseVariableReference(VariableReference object) {
        CodeReference reference = CodeReference.of((GraphicalEvaluationContext)this.getContext(), (EObject)object);
        this.addReference(reference);
        return super.caseVariableReference(object);
    }

    public List<IMetadataEventSelector> getReferencedElements() {
        ArrayList<IMetadataEventSelector> result = new ArrayList<IMetadataEventSelector>();
        result.addAll(this.referencedElements.values());
        return result;
    }

    private void addReference(CodeReference reference) {
        block13: {
            String localPart;
            LinkedList segments = reference.getSegments();
            if (segments.isEmpty()) break block13;
            ISegment iSegment = (ISegment)segments.get(0);
            switch (localPart = iSegment.getQName().getLocalPart()) {
                case "payload": {
                    PayloadEventSelector payloadEventSelector = new PayloadEventSelector();
                    this.referencedElements.put(payloadEventSelector.getId(), (IMetadataEventSelector)payloadEventSelector);
                    break;
                }
                case "attributes": {
                    AttributesEventSelector attributesEventSelector = new AttributesEventSelector();
                    this.referencedElements.put(attributesEventSelector.getId(), (IMetadataEventSelector)attributesEventSelector);
                    break;
                }
                case "vars": {
                    if (segments.size() <= 1) break;
                    VariableEventSelector variableEventSelector = new VariableEventSelector(((ISegment)segments.get(1)).getQName().getLocalPart());
                    this.referencedElements.put(variableEventSelector.getId(), (IMetadataEventSelector)variableEventSelector);
                }
            }
        }
    }
}

