/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.output;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParseException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.tooling.client.ToolingDataWeaveExecutionError;
import org.mule.tooling.client.ToolingDataWeaveExecutionRequest;
import org.mule.tooling.client.ToolingDataWeaveExecutionResponse;
import org.mule.tooling.client.ToolingPropagationInfo;
import org.mule.tooling.client.api.DataWeaveExecutionRequest;
import org.mule.tooling.client.api.DataWeaveExecutionResponse;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.dFL.LiteralValue;
import org.mule.tooling.dfl.dFL.OutputDirective;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.dfl.ui.module.IWeaveUIModule;
import org.mule.tooling.dfl.ui.module.WeaveUIModuleManager;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.dfl.ui.utils.FlatFileSchemaUtils;
import org.mule.tooling.dfl.ui.utils.XTextDocumentQueryHelper;
import org.mule.tooling.event.model.DataTypeModel;
import org.mule.tooling.event.model.TypedValueModel;
import org.mule.tooling.metadata.sample.AttributesEventSelector;
import org.mule.tooling.metadata.sample.IMetadataEventSelector;
import org.mule.tooling.metadata.sample.MetadataSampleService;
import org.mule.tooling.metadata.sample.PayloadEventSelector;
import org.mule.tooling.metadata.sample.VariableEventSelector;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.PreviewExecutedEvent;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.utils.ProjectHelper;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.weave.engine.WeaveEngineHelperManager;
import org.mule.tooling.weave.engine.output.IDFLEngineCallback;
import org.mule.weave.v2.editor.ValidationMessages;

public final class DFLPreviewJob
extends Job {
    private final IDFLEngineCallback callback;
    private SettableFuture<IXtextDocument> documentRef;
    private IMetaDataProvider inputMetadata;
    private IMappingModel messageTransfomer;
    private IMuleProject muleProject;
    private EventBus eventBus;

    public DFLPreviewJob(String name, IDFLEngineCallback callback, SettableFuture<IXtextDocument> documentRef, IMetaDataProvider inputMetadata, IMappingModel messageTransfomer, IMuleProject muleProject, EventBus eventBus) {
        super(name);
        this.callback = callback;
        this.documentRef = documentRef;
        this.inputMetadata = inputMetadata;
        this.messageTransfomer = messageTransfomer;
        this.muleProject = muleProject;
        this.eventBus = eventBus;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IXtextDocument document = (IXtextDocument)Futures.getUnchecked(this.documentRef);
        String dflScript = document.get();
        if (StringUtils.isBlank((String)dflScript)) {
            return Status.OK_STATUS;
        }
        Optional maybeOutputDirective = XTextDocumentQueryHelper.getOutputDirective((IXtextDocument)document);
        if (maybeOutputDirective.isPresent()) {
            OutputDirective outputDirective = (OutputDirective)maybeOutputDirective.get();
            String mimeType = outputDirective.getMimeType();
            IWeaveUIModule weaveModule = WeaveUIModuleManager.getModuleByContentType((String)mimeType);
            if (weaveModule.isBinaryDataFormat()) {
                dflScript = DataWeaveLanguageService.getInstance((IMuleProject)this.muleProject).changeOutputDirective(dflScript, "application/dw");
            }
            try {
                IMuleProject muleProject = this.messageTransfomer.getMuleProject();
                ValidationMessages messages = DataWeaveLanguageService.getInstance((IMuleProject)muleProject).validateScript((IDocument)document, (IDataSenseProvider)IDataSenseProvider.create((PropagationInfo)ToolingPropagationInfo.PropagationInfoBuilder.DEFAULT), true);
                if (messages.errorMessage().length > 0) {
                    return Status.CANCEL_STATUS;
                }
                Optional lookupFunctionCall = XTextDocumentQueryHelper.getLookupFunctionCall((IXtextDocument)document);
                if (lookupFunctionCall.isPresent()) {
                    this.callback.onException(maybeOutputDirective, (DataWeaveExecutionResponse)ToolingDataWeaveExecutionResponse.builder().withException((Exception)new RuntimeException("Cannot show preview for script with 'lookup' function call")).build());
                    return Status.CANCEL_STATUS;
                }
                DataWeaveExecutionResponse previewResult = WeaveEngineHelperManager.executePreview((IMuleProject)muleProject, (IDFLEngineCallback)this.callback, (Optional)maybeOutputDirective, (DataWeaveExecutionRequest)ToolingDataWeaveExecutionRequest.newExecutionRequest().withScript(dflScript).withPayload(this.getPayload()).withAttributes(this.getAttributes()).withVariables(this.getVariables()).build());
                if (!previewResult.isSuccess()) {
                    if (previewResult.isClasspathError()) {
                        ProjectHelper.validateProject(muleProject);
                    }
                    this.callback.onException(maybeOutputDirective, previewResult);
                    return Status.CANCEL_STATUS;
                }
                this.eventBus.fireEvent((IEvent)new PreviewExecutedEvent((String)previewResult.getResult().get(), mimeType, this.getWriterOption(outputDirective)));
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                this.callback.onException(maybeOutputDirective, (DataWeaveExecutionResponse)ToolingDataWeaveExecutionResponse.builder().withException(e).build());
                return Status.CANCEL_STATUS;
            }
        }
        this.callback.onException(maybeOutputDirective, this.createErrorMsg("No output defined"));
        return Status.CANCEL_STATUS;
    }

    private DataWeaveExecutionResponse createErrorMsg(String str) {
        return ToolingDataWeaveExecutionResponse.builder().withErrors(Arrays.asList(ToolingDataWeaveExecutionError.builder().withMessage(str).build())).build();
    }

    private TypedValueModel getPayload() throws IOException, CoreException {
        return this.getTypedValue((IMetadataEventSelector)new PayloadEventSelector());
    }

    private TypedValueModel getTypedValue(IMetadataEventSelector selector) {
        MetadataEvent eventMetadata = this.inputMetadata.getMetadata();
        MetadataSampleService instance = MetadataSampleService.getInstance((IMuleProject)this.muleProject);
        Optional sample = instance.getSample(this.messageTransfomer.getNode(), selector, eventMetadata);
        Optional metadataType = selector.select(eventMetadata);
        if (sample.isPresent() && metadataType.isPresent()) {
            return TypedValueModel.builder().withContent((byte[])sample.get()).withDataType(DataTypeModel.builder().withType("").withMediaType(this.getDataType((MetadataType)metadataType.get())).build()).withTruncated(false).build();
        }
        return null;
    }

    private TypedValueModel getAttributes() {
        return this.getTypedValue((IMetadataEventSelector)new AttributesEventSelector());
    }

    private Map<String, TypedValueModel> getVariables() {
        HashMap<String, TypedValueModel> result = new HashMap<String, TypedValueModel>();
        Collection fields = this.inputMetadata.getMetadata().getVariables().getFields();
        for (ObjectFieldType field : fields) {
            String variableName = field.getKey().getName().getLocalPart();
            result.put(variableName, this.getTypedValue((IMetadataEventSelector)new VariableEventSelector(variableName)));
        }
        return result;
    }

    private String getDataType(MetadataType metadataType) {
        String mediaType;
        IWeaveUIModule moduleByMetaDataModel = WeaveUIModuleManager.getModuleByMetaDataModel((MetadataType)metadataType);
        String baseMediaType = moduleByMetaDataModel.getSampleDataMimeType();
        try {
            MimeType mimeType = new MimeType(baseMediaType);
            Map readerProperties = MetadataTypeHelper.getReaderProperties((MetadataType)metadataType);
            if ("application/flatfile".equals(baseMediaType)) {
                readerProperties.putAll(MetadataTypeHelper.getAdditionalProperties((MetadataType)metadataType));
            }
            FlatFileSchemaUtils.fixSchemaPathIsRequired((IMuleProject)this.muleProject, (Map)readerProperties);
            Set entrySet = readerProperties.entrySet();
            for (Map.Entry entry : entrySet) {
                mimeType.setParameter((String)entry.getKey(), (String)entry.getValue());
            }
            mediaType = mimeType.toString();
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            mediaType = baseMediaType;
        }
        return mediaType;
    }

    private Map<String, Object> getWriterOption(OutputDirective outputDirective) {
        HashMap<String, Object> writerOption = new HashMap<String, Object>();
        if (outputDirective.getOptions() != null) {
            outputDirective.getOptions().getOptions().forEach(oe -> writerOption.put(oe.getName(), ScaffoldingHelper.fromLiteralExpression((LiteralValue)oe.getValue())));
        }
        return writerOption;
    }
}

