/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.output;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.validation.Issue;
import org.mule.tooling.client.api.DataWeaveExecutionError;
import org.mule.tooling.client.api.DataWeaveExecutionResponse;
import org.mule.tooling.dfl.dFL.OutputDirective;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditor;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.output.OutputPreviewEditor;
import org.mule.tooling.ui.dfl.contribution.editor.utils.ProjectHelper;
import org.mule.tooling.ui.widgets.errors.ErrorManager;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.weave.engine.output.IDFLEngineCallback;

public class DFLEngineResultCallback
implements IDFLEngineCallback {
    private EditorContext context;
    private ErrorManager<Document, Issue> errorManager;
    private final OutputPreviewEditor editor;
    private DFLEmbeddedEditor messageTransformerEditor;
    private List<Annotation> previousAnnotations = new ArrayList<Annotation>();

    public DFLEngineResultCallback(OutputPreviewEditor editor, DFLEmbeddedEditor transformerEditor, ErrorManager<Document, Issue> errorManager, EditorContext context) {
        this.editor = editor;
        this.errorManager = errorManager;
        this.messageTransformerEditor = transformerEditor;
        this.context = context;
    }

    public void onResult(final Optional<OutputDirective> outputDirective, final String result) {
        if (!this.isEditorDisposed(this.messageTransformerEditor)) {
            this.clearWarningAndAnnotations();
            this.clearAllAnnotations();
            WidgetUtils.runSilentInAsyncUI((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    String mimeType = ((OutputDirective)outputDirective.get()).getMimeType();
                    DFLEngineResultCallback.this.editor.updateFeedback(mimeType, result);
                    return null;
                }
            }, null);
        }
    }

    private boolean isEditorDisposed(DFLEmbeddedEditor dflEditor) {
        return dflEditor.getViewer().getControl().isDisposed();
    }

    public void onException(Optional<OutputDirective> outputDirective, final DataWeaveExecutionResponse previewResult) {
        if (!this.isEditorDisposed(this.messageTransformerEditor)) {
            this.clearWarningAndAnnotations();
            WidgetUtils.runSilentInAsyncUI((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (!previewResult.isSuccess()) {
                        this.showErrorMarker(previewResult);
                    }
                    return null;
                }

                private void showErrorMarker(DataWeaveExecutionResponse previewResult2) {
                    int offset = 0;
                    int length = 0;
                    DataWeaveExecutionError error = (DataWeaveExecutionError)previewResult2.getErrors().get(0);
                    Optional startIndex = error.getStartIndex();
                    if (startIndex.isPresent()) {
                        Optional endIndex = error.getEndIndex();
                        offset = (Integer)startIndex.get();
                        length = (Integer)endIndex.get() - (Integer)startIndex.get();
                    }
                    String message = error.getMessage().orElse("Failed to execute script.");
                    Annotation annotation = new Annotation("org.eclipse.xtext.ui.editor.warning", false, message);
                    if (!DFLEngineResultCallback.this.isEditorDisposed(DFLEngineResultCallback.this.messageTransformerEditor)) {
                        DFLEngineResultCallback.this.messageTransformerEditor.getViewer().getAnnotationModel().addAnnotation(annotation, new Position(offset, length));
                        DFLEngineResultCallback.this.previousAnnotations.add(annotation);
                        DFLEngineResultCallback.this.errorManager.addIssue((Object)DFLEngineResultCallback.this.messageTransformerEditor.getDocument(), (Object)this.createWarningIssue(offset, length, message));
                    }
                }

                private Issue createWarningIssue(int offset, int length, String message) {
                    Issue.IssueImpl issue = new Issue.IssueImpl();
                    issue.setMessage(message);
                    issue.setLength(Integer.valueOf(length));
                    issue.setOffset(Integer.valueOf(offset));
                    issue.setSeverity(Severity.WARNING);
                    return issue;
                }
            }, null);
        }
    }

    public synchronized void clearWarningAndAnnotations() {
        this.errorManager.deleteAll((Object)this.messageTransformerEditor.getDocument(), input -> Severity.WARNING.equals((Object)input.getSeverity()));
        for (Annotation previousAnnotation : this.previousAnnotations) {
            XtextSourceViewer xtextSourceViewer = this.messageTransformerEditor.getViewer();
            IAnnotationModel annotationModel = xtextSourceViewer.getAnnotationModel();
            if (annotationModel == null) continue;
            annotationModel.removeAnnotation(previousAnnotation);
        }
        this.validateProjectIfNecessary();
    }

    private void clearAllAnnotations() {
        IAnnotationModel annotationModel = this.messageTransformerEditor.getViewer().getAnnotationModel();
        Iterator annotationIterator = annotationModel.getAnnotationIterator();
        ArrayList<Annotation> toBeRemoved = new ArrayList<Annotation>();
        while (annotationIterator.hasNext()) {
            Annotation annotation = (Annotation)annotationIterator.next();
            if (annotation instanceof MarkerAnnotation) continue;
            toBeRemoved.add(annotation);
        }
        for (Annotation annotation : toBeRemoved) {
            annotationModel.removeAnnotation(annotation);
        }
    }

    private void validateProjectIfNecessary() {
        IAnnotationModel annotationModel = this.messageTransformerEditor.getViewer().getAnnotationModel();
        if (annotationModel != null) {
            Iterator annotationIterator = annotationModel.getAnnotationIterator();
            ArrayList<Annotation> currentAnnotations = new ArrayList<Annotation>();
            while (annotationIterator.hasNext()) {
                Annotation annotation = (Annotation)annotationIterator.next();
                if (annotation instanceof MarkerAnnotation) continue;
                currentAnnotations.add(annotation);
            }
            for (Annotation annotation : currentAnnotations) {
                if (!"There are errors in the current classpath".equals(annotation.getText())) continue;
                ProjectHelper.validateProject(this.context.getProject());
            }
        }
    }

    public void showPreviewMessage(final String message) {
        WidgetUtils.runSilentInAsyncUI((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DFLEngineResultCallback.this.editor.showPreviewMessage(message);
                return null;
            }
        }, null);
    }
}

