/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Scanner;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTargetSource;
import org.mule.tooling.utils.InMemoryFile;
import org.mule.tooling.utils.LazyVal;

public class MessageTransformTransformationTargetSource
implements ITransformationTargetSource {
    private PropertyCollection transformationProperties;
    private IMuleProject muleProject;
    private LazyVal<IFile> memoryFile;

    private MessageTransformTransformationTargetSource(final IMuleProject muleProject, PropertyCollection transformationProperties) {
        this.transformationProperties = transformationProperties;
        this.muleProject = muleProject;
        this.memoryFile = new LazyVal<IFile>(){

            protected IFile doGet() {
                return InMemoryFile.createInMemoryFile((String)(UUID.randomUUID().toString() + ".dwl"), (InMemoryFile.IContentHandler)new PropertyCollectionBasedContentProvider(), (IProject)muleProject.getProject());
            }
        };
    }

    @Override
    public String getSourceContent() {
        if (this.isResource()) {
            return this.getFileContent();
        }
        return PropertiesUtils.getPropertyValue((IPropertyCollectionReadCapability)this.transformationProperties, (String)"text", (String)"");
    }

    @Override
    public void setSourceContent(String newContent) {
        try {
            this.getFile().setContents((InputStream)new ByteArrayInputStream(newContent.getBytes()), false, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving resource", e);
        }
    }

    @Override
    public boolean isInline() {
        return !this.isResource();
    }

    @Override
    public boolean isResource() {
        return this.transformationProperties.getProperty("resource") != null;
    }

    @Override
    public String getResource() {
        return this.transformationProperties.getProperty("resource").getValue();
    }

    @Override
    public String getFileName() {
        return CoreUtils.toFileName((String)this.getResource());
    }

    private String getFileContent() {
        String content = null;
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Scanner scanner = new Scanner(this.getFile().getContents());){
                content = scanner.useDelimiter("\\A").next();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchElementException | CoreException throwable) {
            content = "";
        }
        return content;
    }

    @Override
    public void asInline() {
        this.transformationProperties.removeProperty("resource");
        this.transformationProperties.setProperty("auxiliary;erased;resource", "true");
    }

    @Override
    public void asResource(String resourceName) {
        this.transformationProperties.removeProperty("text");
        this.transformationProperties.setProperty("auxiliary;erased;text", "true");
        this.setResource(resourceName);
    }

    @Override
    public void setResource(String name) {
        this.transformationProperties.setProperty("resource", name);
    }

    @Override
    public IFile getFile() {
        if (this.isResource()) {
            Optional resource = CoreUtils.getResource((String)this.getResource(), (IMuleProject)this.muleProject);
            if (resource.isPresent()) {
                return (IFile)resource.get();
            }
            EditingScope editingScope = MuleCorePlugin.getDesignContext().getEditingScope();
            IFile result = this.muleProject.getMuleResourcesFolder(editingScope).getFile(this.getFileName());
            if (!result.exists()) {
                try {
                    IFolder folderHandle = (IFolder)result.getParent();
                    if (!folderHandle.exists()) {
                        IPath path = folderHandle.getFullPath();
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        int numSegments = path.segmentCount();
                        if (numSegments > 2 && !root.getFolder(path.removeLastSegments(1)).exists()) {
                            int i = numSegments - 2;
                            while (i > 0) {
                                IFolder folder = root.getFolder(path.removeLastSegments(i));
                                if (!folder.exists()) {
                                    folder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
                                }
                                --i;
                            }
                        }
                        folderHandle.create(false, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    result.create((InputStream)new ByteArrayInputStream("".getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
        return (IFile)this.memoryFile.get();
    }

    public static MessageTransformTransformationTargetSource wrap(IMuleProject muleProject, PropertyCollection properties) {
        return new MessageTransformTransformationTargetSource(muleProject, properties);
    }

    class PropertyCollectionBasedContentProvider
    implements InMemoryFile.IContentHandler {
        PropertyCollectionBasedContentProvider() {
        }

        public String getContent() {
            return MessageTransformTransformationTargetSource.this.getSourceContent();
        }

        public void setContent(String content) {
            MessageTransformTransformationTargetSource.this.transformationProperties.setProperty("text", content);
        }

        public File getContentFile() {
            return MessageTransformTransformationTargetSource.this.getFile().getFullPath().toFile();
        }
    }
}

