/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.messageflow.IXmlOrder;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.dfl.ui.datasense.MetadataHelper;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTarget;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTargetSource;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.MessageTransformTransformationTargetSource;

public class MessageTransformTransformationTarget
extends Observable
implements ITransformationTarget {
    private PropertyCollection transformationProperties;
    private IMuleProject muleProject;
    private ITransformationTargetSource source;

    private MessageTransformTransformationTarget(IMuleProject muleProject, PropertyCollection transformationProperties) {
        this.muleProject = muleProject;
        this.transformationProperties = transformationProperties;
    }

    public PropertyCollection getPropertyCollection() {
        return this.transformationProperties;
    }

    @Override
    public void setVariableName(String name) {
        this.transformationProperties.setProperty("variableName", name);
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public ITransformationTargetSource getSource() {
        if (this.source == null) {
            this.source = MessageTransformTransformationTargetSource.wrap(this.muleProject, this.transformationProperties);
        }
        return this.source;
    }

    @Override
    public String getLabel() {
        if (this.isPayload()) {
            return "Payload";
        }
        if (!this.isVariable()) {
            return "Attributes";
        }
        return this.getVariableName();
    }

    @Override
    public String getCategory() {
        if (this.transformationProperties.getName().contains("http://www.mulesoft.org/schema/mule/ee/core/set-payload")) {
            return "payload";
        }
        if (this.transformationProperties.getName().contains("http://www.mulesoft.org/schema/mule/ee/core/set-attributes")) {
            return "attributes";
        }
        if (this.transformationProperties.getName().contains("http://www.mulesoft.org/schema/mule/ee/core/set-variable")) {
            return "vars";
        }
        throw new IllegalStateException("Unsupported type" + this.transformationProperties.getName());
    }

    @Override
    public String getVariableName() {
        if (this.isVariable()) {
            Property varNameProperty = this.transformationProperties.getProperty("variableName");
            return varNameProperty != null ? varNameProperty.getValue() : "";
        }
        throw new IllegalStateException("Unsupported type" + this.transformationProperties.getName());
    }

    @Override
    public MetadataType select(MetadataEvent metadata) {
        if (this.isPayload()) {
            return metadata.getPayload();
        }
        if (this.isAttributes()) {
            return metadata.getAttributes();
        }
        return MetadataHelper.getVariableMetadataType((MetadataEvent)metadata, (String)this.getVariableName());
    }

    public static MessageTransformTransformationTarget wrap(IMuleProject muleProject, PropertyCollection propertyCollection) {
        return new MessageTransformTransformationTarget(muleProject, propertyCollection);
    }

    public static MessageTransformTransformationTarget createAttributesInlineTarget(IMuleProject muleProject, IDocumentWrapper document, PropertyCollection messageTransformer, String content) {
        PropertyCollection parentProperties = MessageTransformTransformationTarget.getOrCreateCollection(document, messageTransformer, "http://www.mulesoft.org/schema/mule/ee/core/transform", "http://www.mulesoft.org/schema/mule/ee/core/message");
        PropertyCollection properties = MessageTransformTransformationTarget.createCollection(document, parentProperties, "http://www.mulesoft.org/schema/mule/ee/core/message", "http://www.mulesoft.org/schema/mule/ee/core/set-attributes");
        properties.setProperty("text", content);
        return MessageTransformTransformationTarget.wrap(muleProject, properties);
    }

    public static MessageTransformTransformationTarget createPayloadInlineTarget(IMuleProject muleProject, IDocumentWrapper document, PropertyCollection messageTransformer, String content) {
        PropertyCollection parentProperties = MessageTransformTransformationTarget.getOrCreateCollection(document, messageTransformer, "http://www.mulesoft.org/schema/mule/ee/core/transform", "http://www.mulesoft.org/schema/mule/ee/core/message");
        PropertyCollection properties = MessageTransformTransformationTarget.createCollection(document, parentProperties, "http://www.mulesoft.org/schema/mule/ee/core/message", "http://www.mulesoft.org/schema/mule/ee/core/set-payload");
        properties.setProperty("text", content);
        return MessageTransformTransformationTarget.wrap(muleProject, properties);
    }

    public static MessageTransformTransformationTarget createVariableInlineTarget(IMuleProject muleProject, IDocumentWrapper document, PropertyCollection messageTransformer, String variableName, String script) {
        PropertyCollection parentProperties = MessageTransformTransformationTarget.getOrCreateCollection(document, messageTransformer, "http://www.mulesoft.org/schema/mule/ee/core/transform", "http://www.mulesoft.org/schema/mule/ee/core/variables");
        PropertyCollection properties = MessageTransformTransformationTarget.createCollection(document, parentProperties, "http://www.mulesoft.org/schema/mule/ee/core/variables", "http://www.mulesoft.org/schema/mule/ee/core/set-variable");
        properties.setProperty("variableName", variableName);
        properties.setProperty("text", script);
        return MessageTransformTransformationTarget.wrap(muleProject, properties);
    }

    public static MessageTransformTransformationTarget updateVariableInlineTarget(IMuleProject muleProject, PropertyCollection messageTransformer, String variableName, String script, MessageTransformTransformationTarget oldTarget) {
        PropertyCollection parentProperties = MessageTransformTransformationTarget.getCollection(messageTransformer, "http://www.mulesoft.org/schema/mule/ee/core/variables");
        PropertyCollection properties = PropertiesUtils.newPropertyCollection((PropertyCollection)parentProperties, (String)"http://www.mulesoft.org/schema/mule/ee/core/set-variable", (IElementWrapper)oldTarget.getPropertyCollection().getElement());
        properties.setProperty("variableName", variableName);
        properties.setProperty("text", script);
        return MessageTransformTransformationTarget.wrap(muleProject, properties);
    }

    public static MessageTransformTransformationTarget updatePayloadInlineTarget(IMuleProject muleProject, PropertyCollection messageTransformer, MessageTransformTransformationTarget oldTarget, String content) {
        PropertyCollection parentProperties = MessageTransformTransformationTarget.getCollection(messageTransformer, "http://www.mulesoft.org/schema/mule/ee/core/message");
        PropertyCollection properties = PropertiesUtils.newPropertyCollection((PropertyCollection)parentProperties, (String)"http://www.mulesoft.org/schema/mule/ee/core/set-payload", (IElementWrapper)oldTarget.getPropertyCollection().getElement());
        properties.setProperty("text", content);
        return MessageTransformTransformationTarget.wrap(muleProject, properties);
    }

    public static MessageTransformTransformationTarget updateAttributesInlineTarget(IMuleProject muleProject, PropertyCollection messageTransformer, MessageTransformTransformationTarget oldTarget, String content) {
        PropertyCollection parentProperties = MessageTransformTransformationTarget.getCollection(messageTransformer, "http://www.mulesoft.org/schema/mule/ee/core/message");
        PropertyCollection properties = PropertiesUtils.newPropertyCollection((PropertyCollection)parentProperties, (String)"http://www.mulesoft.org/schema/mule/ee/core/set-attributes", (IElementWrapper)oldTarget.getPropertyCollection().getElement());
        properties.setProperty("text", content);
        return MessageTransformTransformationTarget.wrap(muleProject, properties);
    }

    public static String toClasspathResource(String fileName) {
        return CoreUtils.toClasspathResource((String)fileName);
    }

    private static PropertyCollection getOrCreateCollection(IDocumentWrapper document, PropertyCollection collection, String parentDefinitionId, String definitionId) {
        String collectionKey = PropertiesUtils.findCollectionKey((PropertyCollectionMap)new PropertyCollectionMap(collection), (String)("@" + definitionId));
        return Optional.ofNullable(collectionKey).flatMap(key -> Optional.of(collection.getPropertyCollection(key))).orElseGet(() -> MessageTransformTransformationTarget.createCollection(document, collection, parentDefinitionId, definitionId));
    }

    private static PropertyCollection getCollection(PropertyCollection collection, String definitionId) {
        return MessageTransformTransformationTarget.findCollection(collection, definitionId).orElseThrow(() -> new IllegalStateException("could not find child element with id " + definitionId + " in parent property collection " + String.valueOf(collection)));
    }

    private static Optional<PropertyCollection> findCollection(PropertyCollection collection, String definitionId) {
        String collectionKey = PropertiesUtils.findCollectionKey((PropertyCollectionMap)new PropertyCollectionMap(collection), (String)("@" + definitionId));
        return Optional.ofNullable(collectionKey).flatMap(key -> Optional.of(collection.getPropertyCollection(key)));
    }

    private static PropertyCollection createCollection(IDocumentWrapper document, PropertyCollection collection, String parentDefinitionId, String definitionId) {
        NodeDefinition parentDefinition = MuleCorePlugin.getModuleManager().getDefinition(parentDefinitionId, false);
        parentDefinition = parentDefinition != null ? parentDefinition : MuleCorePlugin.getModuleManager().getNestedDefinition(parentDefinitionId);
        IXmlOrder xmlOrderService = (IXmlOrder)parentDefinition.getService(IXmlOrder.class);
        NestedDefinition nestedDefinition = MuleCorePlugin.getModuleManager().getNestedDefinition(definitionId);
        return PropertiesUtils.newPropertyCollection((PropertyCollection)collection, (String)definitionId, (IElementWrapper)MessageFlowUtils.createElement((IDocumentWrapper)document, (NestedDefinition)nestedDefinition, (int)xmlOrderService.getXmlOrder(definitionId)));
    }

    public int hashCode() {
        if (this.isPayload()) {
            return 31;
        }
        if (!this.isVariable()) {
            return 13;
        }
        int result = 1;
        result = 31 * result + (this.getVariableName() == null ? 0 : this.getVariableName().hashCode());
        result = 31 * result + (this.getCategory() == null ? 0 : this.getCategory().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageTransformTransformationTarget other = (MessageTransformTransformationTarget)obj;
        if (this.isPayload()) {
            return other.isPayload();
        }
        if (other.isPayload()) {
            return this.isPayload();
        }
        if (!this.isVariable()) {
            return !other.isVariable();
        }
        if (!other.isVariable()) {
            return !this.isVariable();
        }
        if (this.getCategory() == null ? other.getCategory() != null : !this.getCategory().equals(other.getCategory())) {
            return false;
        }
        return !(this.getVariableName() == null ? other.getVariableName() != null : !this.getVariableName().equals(other.getVariableName()));
    }

    public static List<ITransformationTarget> findTargets(IMuleProject project, PropertyCollection newPropertyCollection) {
        Stream messageStream = MessageTransformTransformationTarget.findCollection(newPropertyCollection, "http://www.mulesoft.org/schema/mule/ee/core/message").flatMap(messageCollection -> Optional.of(MessageTransformTransformationTarget.getNestedElementProperties(messageCollection, "http://www.mulesoft.org/schema/mule/ee/core/set-payload", "http://www.mulesoft.org/schema/mule/ee/core/set-attributes").stream())).orElse(Stream.empty());
        Stream variablesStream = MessageTransformTransformationTarget.findCollection(newPropertyCollection, "http://www.mulesoft.org/schema/mule/ee/core/variables").flatMap(variablesCollection -> Optional.of(MessageTransformTransformationTarget.getNestedElementProperties(variablesCollection, "http://www.mulesoft.org/schema/mule/ee/core/set-variable").stream())).orElse(Stream.empty());
        return Stream.concat(messageStream, variablesStream).filter(IPropertyCollectionReadCapability::notErased).map(props -> MessageTransformTransformationTarget.wrap(project, props)).collect(Collectors.toList());
    }

    public static List<PropertyCollection> getNestedElementProperties(PropertyCollection currentPropertyCollection, String ... nestedElementIds) {
        List propertyCollections = currentPropertyCollection.getPropertyCollections();
        ArrayList<PropertyCollection> propertyCollectionsToReturn = new ArrayList<PropertyCollection>();
        for (PropertyCollection propertyCollection : propertyCollections) {
            String[] stringArray = nestedElementIds;
            int n = nestedElementIds.length;
            int n2 = 0;
            while (n2 < n) {
                String nestedElementId = stringArray[n2];
                if (propertyCollection.getName().contains(nestedElementId + ";")) {
                    propertyCollectionsToReturn.add(propertyCollection);
                }
                ++n2;
            }
        }
        return propertyCollectionsToReturn;
    }

    @Override
    public void dispose() {
        this.deleteObservers();
    }
}

