/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.model;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.ui.datasense.MetadataHelper;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.ui.dfl.contribution.editor.action.TargetScope;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.TransformationTargetAddedEvent;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.TransformationTargetRemovedEvent;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTarget;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.MessageTransformTransformationTarget;
import org.mule.tooling.ui.modules.core.metadata.IPropagationInfoProvider;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;

public class MessageTransformMappingModel
implements IMappingModel {
    private EventBus eventBus;
    private PatternNode patternNode;
    private IMuleProject muleProject;
    private PropertyCollection newPropertyCollection;

    public MessageTransformMappingModel(IMuleProject muleProject, PatternNode patternNode, EventBus eventBus, PropertyCollection newPropertyCollection) {
        this.eventBus = eventBus;
        this.muleProject = muleProject;
        this.patternNode = patternNode;
        this.newPropertyCollection = newPropertyCollection;
    }

    @Override
    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public PatternNode getNode() {
        return this.patternNode;
    }

    @Override
    public List<ITransformationTarget> getTargets() {
        return MessageTransformTransformationTarget.findTargets(this.muleProject, this.newPropertyCollection);
    }

    private ITransformationTarget newAttributesTransformation(MetadataType model) {
        String content = this.generateDefaultScript(model);
        return this.newAttributesTransformation(content);
    }

    private ITransformationTarget newAttributesTransformation(String content) {
        MessageTransformTransformationTarget transformationTarget = MessageTransformTransformationTarget.createAttributesInlineTarget(this.muleProject, this.getDocument(), this.newPropertyCollection, content);
        this.eventBus.fireEvent((IEvent)new TransformationTargetAddedEvent(transformationTarget));
        return transformationTarget;
    }

    @Override
    public ITransformationTarget newPayloadTransformation(MetadataType payloadType) {
        String content = this.generateDefaultScript(payloadType);
        return this.newPayloadTransformation(content);
    }

    public ITransformationTarget newPayloadTransformation(String content) {
        MessageTransformTransformationTarget transformationTarget = MessageTransformTransformationTarget.createPayloadInlineTarget(this.muleProject, this.getDocument(), this.newPropertyCollection, content);
        this.eventBus.fireEvent((IEvent)new TransformationTargetAddedEvent(transformationTarget));
        return transformationTarget;
    }

    public ITransformationTarget updateAttributesTransformation(String content, ITransformationTarget oldTarget) {
        MessageTransformTransformationTarget transformationTarget = MessageTransformTransformationTarget.updateAttributesInlineTarget(this.muleProject, this.newPropertyCollection, (MessageTransformTransformationTarget)oldTarget, content);
        this.eventBus.fireEvent((IEvent)new TransformationTargetAddedEvent(transformationTarget));
        return transformationTarget;
    }

    private String generateDefaultScript(MetadataType payloadType) {
        Document output = ScaffoldingHelper.buildEmptyDocument((MetadataType)payloadType);
        return ScaffoldingHelper.toString((Document)output);
    }

    public ITransformationTarget newVariableTransformation(String variableName, MetadataType propertyMetadata) {
        MessageTransformTransformationTarget target = MessageTransformTransformationTarget.createVariableInlineTarget(this.muleProject, this.getDocument(), this.newPropertyCollection, variableName, this.generateDefaultScript(propertyMetadata));
        this.eventBus.fireEvent((IEvent)new TransformationTargetAddedEvent(target));
        return target;
    }

    public ITransformationTarget updateVariableTransformation(String variableName, MetadataType propertyMetadata, ITransformationTarget oldTarget) {
        MessageTransformTransformationTarget target = MessageTransformTransformationTarget.updateVariableInlineTarget(this.muleProject, this.newPropertyCollection, variableName, this.generateDefaultScript(propertyMetadata), (MessageTransformTransformationTarget)oldTarget);
        this.eventBus.fireEvent((IEvent)new TransformationTargetAddedEvent(target));
        return target;
    }

    @Override
    public void removeTransformationTarget(ITransformationTarget target) {
        if (this.getTargets().size() > 1) {
            this.doRemoveTransformationTarget(target);
        }
    }

    private void doRemoveTransformationTarget(ITransformationTarget target) {
        ((MessageTransformTransformationTarget)target).getPropertyCollection().setErased(true);
        this.eventBus.fireEvent((IEvent)new TransformationTargetRemovedEvent(target));
    }

    @Override
    public boolean isPayloadTargetDeclared() {
        return this.getTargets().stream().filter(new IsPayloadFilter()).findAny().isPresent();
    }

    @Override
    public boolean isAttributesTargetDeclared() {
        return this.getTargets().stream().anyMatch(target -> !target.isPayload() && !target.isVariable());
    }

    @Override
    public boolean isTargetDeclared(String category, String name) {
        return this.getTargets().stream().filter(new IsTargetFilter(category, name)).findAny().isPresent();
    }

    @Override
    public ITransformationTarget replaceTransformationTarget(ITransformationTarget target, TargetScope selectedType, String selectedName, MetadataType model) {
        this.doRemoveTransformationTarget(target);
        return this.createTransformationTarget(selectedType, selectedName, model);
    }

    @Override
    public ITransformationTarget createTransformationTarget(TargetScope selectedType, String selectedName, MetadataType model) {
        switch (selectedType) {
            case PAYLOAD: {
                return this.newPayloadTransformation(model);
            }
            case ATTRIBUTES: {
                return this.newAttributesTransformation(model);
            }
        }
        return this.newVariableTransformation(selectedName, model);
    }

    private IDocumentWrapper getDocument() {
        return this.patternNode.getElement().getDocument();
    }

    @Override
    public boolean supportsMultipleTargets() {
        return true;
    }

    @Override
    public boolean supportsUpdateOutputHeader() {
        return true;
    }

    @Override
    public void setOuputMetadata(MessageRowType rowType, Optional<String> variableName, MetadataResult result, IPropagationInfoProvider provider) {
        MetadataHelper.updateMetadata((MessageRowType)rowType, (IMessageFlowNode)this.getNode(), (IMuleProject)this.getMuleProject(), variableName, (MetadataResult)result);
        provider.reloadPropagation();
    }

    @Override
    public void clearOutputMetadata(MessageRowType rowType, Optional<String> variableName, IPropagationInfoProvider provider) {
        MetadataHelper.updateMetadata((MessageRowType)rowType, (IMessageFlowNode)this.getNode(), (IMuleProject)this.getMuleProject(), variableName, (MetadataResult)MetadataResult.createEmpty());
        provider.reloadPropagation();
    }

    private static class IsPayloadFilter
    implements Predicate<ITransformationTarget> {
        private IsPayloadFilter() {
        }

        @Override
        public boolean test(ITransformationTarget input) {
            return input.isPayload();
        }
    }

    private static class IsTargetFilter
    implements Predicate<ITransformationTarget> {
        private String category;
        private String name;

        public IsTargetFilter(String category, String name) {
            this.category = category;
            this.name = name;
        }

        @Override
        public boolean test(ITransformationTarget input) {
            return input.isVariable() && this.category != null && this.category.equals(input.getCategory()) && this.name != null && this.name.equals(input.getVariableName());
        }
    }
}

