/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionEditor;
import org.mule.tooling.ui.modules.core.metadata.definition.IMetadataDefinitionWizardCallback;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizard;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizardPage;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;

public class VariableMetadataDefinitionWizard
extends MetadataDefinitionWizard {
    private String name;
    private String typeName;
    private VariableMetadataDefinitionWizardPage variableMetadataDefinitionWizardPage;

    public VariableMetadataDefinitionWizard(IMuleProject muleProject, String typeName) {
        super(muleProject);
        this.typeName = typeName;
    }

    public String getVariableName() {
        return this.name;
    }

    public void addPages() {
        this.variableMetadataDefinitionWizardPage = new VariableMetadataDefinitionWizardPage(this.muleProject, this.callback, this.typeName);
        this.addPage((IWizardPage)this.variableMetadataDefinitionWizardPage);
    }

    public boolean performFinish() {
        this.name = this.variableMetadataDefinitionWizardPage.nameText.getText();
        return super.performFinish();
    }

    private static final class VariableMetadataDefinitionWizardPage
    extends MetadataDefinitionWizardPage {
        private String typeName;
        private Text nameText;

        public VariableMetadataDefinitionWizardPage(IMuleProject muleProject, IMetadataDefinitionWizardCallback metadataDefinitionWizardCallback, String typeName) {
            super(muleProject, metadataDefinitionWizardCallback);
            this.typeName = typeName;
        }

        public void createControl(Composite parent) {
            Composite wrapper = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(wrapper);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
            Composite nameContainer = new Composite(wrapper, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(nameContainer);
            GridDataFactory.fillDefaults().applyTo((Control)nameContainer);
            Label nameLabel = new Label(nameContainer, 0);
            nameLabel.setText(this.typeName + " Name:");
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)nameLabel);
            this.nameText = new Text(nameContainer, 2052);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
            this.nameText.addModifyListener((ModifyListener)new IdleModifyEventListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.setMessage(null);
                    this.getContentEditor().validate();
                }
            }, (Control)this.nameText));
            Label separator = new Label(wrapper, 258);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)separator);
            super.createControl(wrapper);
            this.nameText.setFocus();
        }

        protected boolean validateCompletion(IMetadataDefinitionEditor editor) {
            boolean isNameNotBlank = StringUtils.isNotBlank((String)this.nameText.getText());
            return isNameNotBlank && super.validateCompletion(editor);
        }

        public void setPageComplete(boolean complete) {
            boolean variableNameIsEmpty = StringUtils.isEmpty((String)this.nameText.getText());
            if (variableNameIsEmpty) {
                this.setMessage(this.typeName + " name cannot be empty", 3);
            }
            super.setPageComplete(complete && !variableNameIsEmpty);
        }
    }
}

