/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.utils.ImagesHelper;
import org.mule.tooling.metadata.sample.AttributesEventSelector;
import org.mule.tooling.metadata.sample.IMetadataEventSelector;
import org.mule.tooling.metadata.sample.PayloadEventSelector;
import org.mule.tooling.metadata.sample.VariableEventSelector;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.AbstractMetaDataTreeAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.InputViewer;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class SpecifySampleDataAction
extends AbstractMetaDataTreeAction {
    public static final String PAYLOAD_SAMPLE_DATA_ID = "payload";
    public static final String ATTRIBUTES_SAMPLE_DATA_ID = "attributes";
    private final InputViewer inputViewer;

    public SpecifySampleDataAction(GraphicalTreeNode<?> treeNode, IMetaDataProvider metaDataProvider, InputViewer inputViewer) {
        super("Edit Sample Data", ImagesHelper.getImageDescriptor((String)"icons/edit_input.png"), treeNode, metaDataProvider);
        this.inputViewer = inputViewer;
    }

    protected InputViewer getInputViewer() {
        return this.inputViewer;
    }

    public void run() {
        IMetadataEventSelector selector = this.createId();
        if (this.inputViewer.containsSampleDataTab(selector.getId())) {
            this.inputViewer.showSampleDataTab(selector.getId());
        } else {
            this.createSample(selector);
        }
    }

    private IMetadataEventSelector createId() {
        if (this.treeNode.getId().equals(PAYLOAD_SAMPLE_DATA_ID)) {
            return new PayloadEventSelector();
        }
        if (this.treeNode.getId().equals(ATTRIBUTES_SAMPLE_DATA_ID)) {
            return new AttributesEventSelector();
        }
        if (this.treeNode.getParent().getId().equals("vars")) {
            return new VariableEventSelector(this.treeNode.getId());
        }
        return null;
    }

    protected void createSample(IMetadataEventSelector id) {
        this.inputViewer.createSample(this.getMetadataType(), id);
    }
}

