/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import java.util.Optional;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.dfl.ui.datasense.MetadataHelper;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.utils.GraphicalTreeNodeUtils;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.UpdateMetadataOperation;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.AbstractMetaDataTreeAction;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizard;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizardDialog;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class SetMetadataAction
extends AbstractMetaDataTreeAction {
    private final TwoWayHandler twoWayHandler;
    private final Optional<MessageRowType> maybeCurrentRowType;

    public SetMetadataAction(TwoWayHandler twoWayHandler, IMetaDataProvider metaDataProvider, GraphicalTreeNode<?> treeNode) {
        super("Set Metadata", treeNode, metaDataProvider);
        this.twoWayHandler = twoWayHandler;
        this.maybeCurrentRowType = GraphicalTreeNodeUtils.isUnresolvedMetadataNodeId(treeNode) ? Optional.empty() : Optional.ofNullable(metaDataProvider.isPayload(treeNode.getId()) ? MessageRowType.INPUT_PAYLOAD : (metaDataProvider.isAttributes(treeNode.getId()) ? MessageRowType.INPUT_ATTRIBUTES : (MessageRowType)MetadataHelper.getCurrentMessageRowType((GraphicalTreeNode)treeNode.getParent()).get()));
    }

    public void run() {
        this.maybeCurrentRowType.ifPresent(currentRowType -> {
            Optional<MetadataResult> result = this.openMetadataDefinitionWizard();
            if (result.isPresent()) {
                MetadataResult metadataResult = result.get();
                UpdateMetadataOperation updateOperation = new UpdateMetadataOperation(this.twoWayHandler, metadataResult, (MessageRowType)currentRowType, (GraphicalTreeNode<?>)this.treeNode);
                updateOperation.update();
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.maybeCurrentRowType.isPresent();
    }

    private Optional<MetadataResult> openMetadataDefinitionWizard() {
        Optional<MetadataResult> result = Optional.empty();
        MetadataDefinitionWizard wizard = new MetadataDefinitionWizard(this.twoWayHandler.getProject());
        Shell activeShell = Display.getCurrent().getActiveShell();
        MetadataDefinitionWizardDialog dialog = new MetadataDefinitionWizardDialog(activeShell, wizard);
        if (dialog.open() == 0) {
            result = Optional.of(wizard.getResult());
        }
        return result;
    }
}

